/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.util.Calendar;
import java.util.Locale;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.date.TimeStamp;
import org.jclouds.encryption.internal.Base64;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.Credential;

@Singleton
public class RequestAuthenticator
implements HttpRequestFilter,
RequestSigner {
    @Resource
    @Named(value="jclouds.signature")
    private Logger signatureLog = Logger.NULL;
    final Provider<Calendar> calendarProvider;
    final Signature signer;
    final Provider<UriBuilder> builder;
    final String apiVersion;
    public String signatureVersion = "1.0";
    public String signatureMethod = "SHA1withRSA";
    private HttpUtils utils;

    @Inject
    public RequestAuthenticator(@TimeStamp Provider<Calendar> calendarProvider, Provider<KeyStore> keyStoreProvider, @Credential String keyPassword, Provider<UriBuilder> builder, HttpUtils utils, SignatureWire signatureWire, @ApiVersion String apiVersion) throws NoSuchAlgorithmException, InvalidKeyException, KeyStoreException, UnrecoverableKeyException {
        this.calendarProvider = (Provider)Preconditions.checkNotNull(calendarProvider);
        this.builder = (Provider)Preconditions.checkNotNull(builder);
        this.utils = (HttpUtils)Preconditions.checkNotNull((Object)utils, (Object)"utils");
        this.apiVersion = (String)Preconditions.checkNotNull((Object)apiVersion, (Object)"apiVersion");
        this.signer = Signature.getInstance(this.signatureMethod);
        KeyStore keyStore = (KeyStore)((Provider)Preconditions.checkNotNull(keyStoreProvider)).get();
        String alias = keyStore.aliases().nextElement();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, keyPassword.toCharArray());
        this.signer.initSign(privateKey);
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        String lang;
        Preconditions.checkNotNull((Object)request, (Object)"request must be present");
        this.utils.logRequest(this.signatureLog, request, ">>");
        String accessKeyId = this.createStringToSign(request);
        String signature = this.sign(accessKeyId);
        String string = lang = Locale.JAPANESE.getLanguage().equals(Locale.getDefault().getLanguage()) ? Locale.JAPANESE.getLanguage() : Locale.ENGLISH.getLanguage();
        if ("GET".equals(request.getMethod())) {
            Multimap decodedParams = Queries.parseQueryToMap((String)request.getEndpoint().getRawQuery());
            if (!decodedParams.containsKey((Object)"Version")) {
                decodedParams.put((Object)"Version", (Object)this.apiVersion);
            }
            decodedParams.put((Object)"Locale", (Object)lang);
            decodedParams.put((Object)"AccessKeyId", (Object)accessKeyId);
            decodedParams.put((Object)"Signature", (Object)signature);
            request = request.toBuilder().replaceQueryParams(decodedParams).build();
        } else {
            String payload = request.getPayload().getRawContent().toString();
            payload = this.createXmlElementWithValue(payload, "Version", this.apiVersion);
            payload = this.createXmlElementWithValue(payload, "Locale", lang);
            payload = this.createXmlElementWithValue(payload, "AccessKeyId", accessKeyId);
            payload = this.createXmlElementWithValue(payload, "Signature", signature);
            request.setPayload(payload);
            request.getPayload().getContentMetadata().setContentType("text/xml");
        }
        HttpRequest filteredRequest = ((HttpRequest.Builder)request.toBuilder().replaceHeader("User-Agent", new String[]{"OViSS-API-CLIENT"})).build();
        this.utils.logRequest(this.signatureLog, filteredRequest, ">>->");
        return filteredRequest;
    }

    String createXmlElementWithValue(String payload, String tag, String value) {
        String startTag = String.format("<%s>", tag);
        String endTag = String.format("</%s>", tag);
        return payload.replace(startTag + endTag, startTag + value + endTag);
    }

    @VisibleForTesting
    public String sign(String stringToSign) {
        String signed;
        try {
            this.signer.update(stringToSign.getBytes("UTF-8"));
            signed = Base64.encodeBytes((byte[])this.signer.sign()).replace("\n", "\r\n");
        }
        catch (Exception e) {
            throw new HttpException("error signing request", (Throwable)e);
        }
        return signed;
    }

    @VisibleForTesting
    public String generateAccessKeyId() {
        Calendar cal = (Calendar)this.calendarProvider.get();
        String timezone = cal.getTimeZone().getDisplayName(Locale.ENGLISH);
        String expires = String.valueOf(cal.getTime().getTime());
        String signatureData = String.format("%s&%s&%s&%s", timezone, expires, this.signatureVersion, this.signatureMethod);
        try {
            String accessKeyId = Base64.encodeBytes((byte[])signatureData.getBytes("UTF-8"));
            return accessKeyId.replace("\n", "\r\n");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String createStringToSign(HttpRequest input) {
        return this.generateAccessKeyId();
    }
}

