/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.fujitsu.fgcp.domain.PublicIP;
import org.jclouds.fujitsu.fgcp.domain.VDisk;
import org.jclouds.fujitsu.fgcp.domain.VNet;
import org.jclouds.fujitsu.fgcp.domain.VServerWithVNICs;
import org.jclouds.fujitsu.fgcp.domain.VSystem;

@XmlRootElement(name="vsys")
public class VSystemWithDetails
extends VSystem {
    @XmlElementWrapper(name="vservers")
    @XmlElement(name="vserver")
    private Set<VServerWithVNICs> servers = new LinkedHashSet<VServerWithVNICs>();
    @XmlElementWrapper(name="vdisks")
    @XmlElement(name="vdisk")
    private Set<VDisk> disks = new LinkedHashSet<VDisk>();
    @XmlElementWrapper(name="publicips")
    @XmlElement(name="publicip")
    private Set<PublicIP> publicips = new LinkedHashSet<PublicIP>();
    @XmlElementWrapper(name="vnets")
    @XmlElement(name="vnet")
    private Set<VNet> networks = new LinkedHashSet<VNet>();

    public Set<VServerWithVNICs> getServers() {
        return this.servers == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.servers);
    }

    public Set<VDisk> getDisks() {
        return this.disks == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.disks);
    }

    public Set<PublicIP> getPublicips() {
        return this.publicips == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.publicips);
    }

    public Set<VNet> getNetworks() {
        return this.networks == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.networks);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("creator", (Object)this.creator).add("template", (Object)this.template).add("description", (Object)this.description).add("disks", this.disks).add("networks", this.networks).add("publicips", this.publicips).add("servers", this.servers).toString();
    }
}

