/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.fujitsu.fgcp.domain.Product;

@XmlRootElement(name="usageinfo")
public class UsageInfo {
    @XmlElement(name="vsysId")
    private String systemId;
    @XmlElement(name="vsysName")
    private String systemName;
    @XmlElementWrapper(name="products")
    @XmlElement(name="product")
    private Set<Product> products = new LinkedHashSet<Product>();

    public String getSystemId() {
        return this.systemId;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public Set<Product> getProducts() {
        return this.products == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.products);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.systemId, this.systemName, this.products});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsageInfo that = (UsageInfo)UsageInfo.class.cast(obj);
        return Objects.equal((Object)this.systemId, (Object)that.systemId) && Objects.equal((Object)this.systemName, (Object)that.systemName) && Objects.equal(this.products, that.products);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("systemId", (Object)this.systemId).add("systemName", (Object)this.systemName).add("products", this.products).toString();
    }
}

