/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.fujitsu.fgcp.domain.CPU;
import org.jclouds.fujitsu.fgcp.domain.Disk;
import org.jclouds.fujitsu.fgcp.domain.Memory;

@XmlRootElement(name="servertype")
public class ServerType
implements Comparable<ServerType> {
    private String id;
    private String name;
    private String label;
    private String comment;
    private String productId;
    private String productName;
    private String price;
    private String chargeType;
    private String expectedUsage;
    private CPU cpu;
    private Memory memory;
    @XmlElementWrapper(name="disks")
    @XmlElement(name="disk")
    private Set<Disk> disks = Sets.newLinkedHashSet();

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getComment() {
        return this.comment;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getPrice() {
        return this.price;
    }

    public String getChargeType() {
        return this.chargeType;
    }

    public String getExpectedUsage() {
        return this.expectedUsage;
    }

    public CPU getCpu() {
        return this.cpu;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public Set<Disk> getDisks() {
        return this.disks == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.disks);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerType that = (ServerType)ServerType.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("label", (Object)this.label).add("comment", (Object)this.comment).add("productId", (Object)this.productId).add("productName", (Object)this.productName).add("price", (Object)this.price).add("chargeType", (Object)this.chargeType).add("expectedUsage", (Object)this.expectedUsage).add("cpu", (Object)this.cpu).add("memory", (Object)this.memory).add("disks", this.disks).toString();
    }

    @Override
    public int compareTo(ServerType o) {
        return this.memory == null ? -1 : this.memory.compareTo(o.memory);
    }
}

