/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.xml.bind.annotation.XmlElement;

public class PublicIP {
    protected String address;
    @XmlElement(name="v4v6Flag")
    protected Version version;

    public String getAddress() {
        return this.address;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.address});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublicIP that = (PublicIP)PublicIP.class.cast(obj);
        return Objects.equal((Object)this.address, (Object)that.address);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("address", (Object)this.address).add("version", (Object)this.version).toString();
    }

    public static enum Version {
        IPv4,
        IPv6,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static Version fromValue(String version) {
            try {
                return Version.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)version, (Object)"version")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

