/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jclouds.fujitsu.fgcp.domain.Cause;
import org.jclouds.fujitsu.fgcp.domain.Target;

public class Group {
    private int id;
    private String protocol;
    private int port1;
    private int port2;
    private String balanceType;
    private String uniqueType;
    private String monitorType;
    private int maxConnection;
    private int uniqueRetention;
    private int interval;
    private int timeout;
    private int retryCount;
    private int certNum;
    private Set<Cause> causes;
    private RecoveryAction recoveryAction;
    private Set<Target> targets = new LinkedHashSet<Target>();
    private String validity;

    public int getId() {
        return this.id;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort1() {
        return this.port1;
    }

    public int getPort2() {
        return this.port2;
    }

    public String getBalanceType() {
        return this.balanceType;
    }

    public String getUniqueType() {
        return this.uniqueType;
    }

    public String getMonitorType() {
        return this.monitorType;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public int getUniqueRetention() {
        return this.uniqueRetention;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getCertNum() {
        return this.certNum;
    }

    public Set<Cause> getCauses() {
        return this.causes == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.causes);
    }

    public RecoveryAction getRecoveryAction() {
        return this.recoveryAction;
    }

    public Set<Target> getTargets() {
        return this.targets == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.targets);
    }

    public String getValidity() {
        return this.validity;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group that = (Group)Group.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", this.id).add("protocol", (Object)this.protocol).add("port1", this.port1).add("port2", this.port2).add("balanceType", (Object)this.balanceType).add("uniqueType", (Object)this.uniqueType).add("monitorType", (Object)this.monitorType).add("maxConnection", this.maxConnection).add("uniqueRetention", this.uniqueRetention).add("interval", this.interval).add("timeout", this.timeout).add("retryCount", this.retryCount).add("certNum", this.certNum).add("causes", this.causes).add("recoveryAction", (Object)this.recoveryAction).add("targets", this.targets).add("validity", (Object)this.validity).toString();
    }

    static enum RecoveryAction {
        SWITCH_BACK,
        MAINTENANCE;

    }
}

