/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.fujitsu.fgcp.domain.Software;

@XmlRootElement(name="diskimage")
public class DiskImage {
    @XmlElement(name="diskimageId")
    private String id;
    @XmlElement(name="diskimageName")
    private String name;
    private int size;
    private String osName;
    private String osType;
    private String creatorName;
    private String registrant;
    private String licenseInfo;
    private String description;
    @XmlElementWrapper(name="softwares")
    @XmlElement(name="software")
    private Set<Software> software = new LinkedHashSet<Software>();

    public String getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsType() {
        return this.osType;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public String getLicenseInfo() {
        return this.licenseInfo;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Set<Software> getSoftware() {
        return this.software == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.software);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiskImage that = (DiskImage)DiskImage.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("osName", (Object)this.osName).add("osType", (Object)this.osType).add("size", this.size).add("creatorName", (Object)this.creatorName).add("description", (Object)this.description).add("licenseInfo", (Object)this.licenseInfo).add("registrant", (Object)this.registrant).add("software", this.software).toString();
    }

    public static class Builder {
        private String id;
        private String name;
        private int size;
        private String osName;
        private String osType;
        private String creatorName;
        private String registrant;
        private String licenseInfo;
        private String description;
        private Set<Software> software;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder osName(String osName) {
            this.osName = osName;
            return this;
        }

        public Builder osType(String osType) {
            this.osType = osType;
            return this;
        }

        public Builder creatorName(String creatorName) {
            this.creatorName = creatorName;
            return this;
        }

        public Builder registrant(String registrant) {
            this.registrant = registrant;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public DiskImage build() {
            DiskImage image = new DiskImage();
            image.id = this.id;
            image.name = this.name;
            image.size = this.size;
            image.osName = this.osName;
            image.osType = this.osType;
            image.creatorName = this.creatorName;
            image.registrant = this.registrant;
            image.licenseInfo = this.licenseInfo;
            image.description = this.description;
            image.software = this.software;
            return image;
        }
    }
}

