/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jclouds.fujitsu.fgcp.domain.Policy;

public class Direction {
    private String from;
    private String to;
    private Set<Policy> policies = new LinkedHashSet<Policy>();
    private Acceptable acceptable;
    private Prefix prefix;
    private int maxPolicyNum;

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public Set<Policy> getPolicies() {
        return this.policies == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.policies);
    }

    public Acceptable getAcceptable() {
        return this.acceptable;
    }

    public Prefix getPrefix() {
        return this.prefix;
    }

    public int getMaxPolicyNum() {
        return this.maxPolicyNum;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.from, this.to});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Direction that = (Direction)Direction.class.cast(obj);
        return Objects.equal((Object)this.from, (Object)that.from) && Objects.equal((Object)this.to, (Object)that.to);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("from", (Object)this.from).add("to", (Object)this.to).add("prefix", (Object)this.prefix).add("policies", this.policies).add("maxPolicyNum", this.maxPolicyNum).add("acceptable", (Object)this.acceptable).toString();
    }

    static enum Prefix {
        free,
        src,
        dst,
        proto,
        srcport,
        dstport,
        action,
        rule,
        tab;

    }

    static enum Acceptable {
        OK,
        NG;

    }
}

