/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.compute.domain.Template;
import org.jclouds.fujitsu.fgcp.domain.DiskImage;
import org.jclouds.fujitsu.fgcp.domain.PublicIP;
import org.jclouds.fujitsu.fgcp.domain.VServer;
import org.jclouds.fujitsu.fgcp.domain.VServerStatus;
import org.jclouds.fujitsu.fgcp.domain.VServerWithVNICs;

public class VServerMetadata {
    protected VServer server;
    protected String id;
    protected String name;
    protected Template template;
    protected String initialPassword;
    protected VServerStatus status = VServerStatus.UNRECOGNIZED;
    protected Set<PublicIP> ips;
    protected DiskImage image;

    public VServerMetadata(VServer server, String initialPassword, VServerStatus status, DiskImage image, Set<PublicIP> publicIps) {
        this.server = (VServer)Preconditions.checkNotNull((Object)server, (Object)"server");
        this.initialPassword = initialPassword;
        this.status = status;
        this.image = image;
        this.ips = publicIps;
        this.id = server.getId();
        this.name = server.getName();
    }

    public VServerMetadata(String id, String name, Template template, VServerStatus status) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.template = (Template)Preconditions.checkNotNull((Object)template, (Object)"template");
        this.status = (VServerStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
    }

    public VServer getServer() {
        return this.server;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public String getInitialPassword() {
        return this.initialPassword;
    }

    public VServerStatus getStatus() {
        return this.status;
    }

    public Set<PublicIP> getIps() {
        return this.ips;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private VServer server;
        private VServerWithVNICs serverWithDetails;
        private String id;
        private String name;
        private Template template;
        private String initialPassword;
        private VServerStatus status = VServerStatus.UNRECOGNIZED;
        private Set<PublicIP> publicIps = ImmutableSet.of();
        private DiskImage image;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder template(Template template) {
            this.template = template;
            return this;
        }

        public Builder serverWithDetails(VServerWithVNICs serverWithDetails) {
            this.serverWithDetails = serverWithDetails;
            return this;
        }

        public Builder initialPassword(String password) {
            this.initialPassword = password;
            return this;
        }

        public Builder status(VServerStatus status) {
            this.status = status;
            return this;
        }

        public Builder image(DiskImage image) {
            this.image = image;
            return this;
        }

        public Builder publicIps(Set<PublicIP> publicIps) {
            this.publicIps = publicIps;
            return this;
        }

        public VServerMetadata build() {
            if (this.initialPassword == null) {
                this.initialPassword = "";
            }
            if (this.server != null) {
                return new VServerMetadata(this.server, this.initialPassword, this.status, this.image, this.publicIps);
            }
            if (this.serverWithDetails != null) {
                return new VServerMetadata(this.serverWithDetails, this.initialPassword, this.status, this.image, this.publicIps);
            }
            if (this.id == null) {
                this.id = "dummy-id";
            }
            if (this.name == null) {
                this.name = "dummy-name";
            }
            return new VServerMetadata(this.id, this.name, this.template, this.status);
        }
    }
}

