/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.fujitsu.fgcp.FGCPApi;
import org.jclouds.fujitsu.fgcp.FGCPAsyncApi;
import org.jclouds.fujitsu.fgcp.compute.functions.ResourceIdToFirewallId;
import org.jclouds.fujitsu.fgcp.compute.functions.ResourceIdToSystemId;
import org.jclouds.fujitsu.fgcp.compute.predicates.ServerStopped;
import org.jclouds.fujitsu.fgcp.compute.predicates.SystemStatusNormal;
import org.jclouds.fujitsu.fgcp.compute.strategy.VServerMetadata;
import org.jclouds.fujitsu.fgcp.domain.DiskImage;
import org.jclouds.fujitsu.fgcp.domain.ServerType;
import org.jclouds.fujitsu.fgcp.domain.VServerStatus;
import org.jclouds.fujitsu.fgcp.domain.VServerWithDetails;
import org.jclouds.fujitsu.fgcp.domain.VServerWithVNICs;
import org.jclouds.fujitsu.fgcp.domain.VSystem;
import org.jclouds.fujitsu.fgcp.domain.VSystemWithDetails;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;

@Singleton
public class FGCPComputeServiceAdapter
implements ComputeServiceAdapter<VServerMetadata, ServerType, DiskImage, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final FGCPApi api;
    private final FGCPAsyncApi asyncApi;
    protected Predicate<String> serverStopped = null;
    protected Predicate<String> serverCreated = null;
    protected Predicate<String> systemNormal = null;
    protected ResourceIdToFirewallId toFirewallId = null;
    protected ResourceIdToSystemId toSystemId = null;

    @Inject
    public FGCPComputeServiceAdapter(FGCPApi api, FGCPAsyncApi asyncApi, ServerStopped serverStopped, SystemStatusNormal systemNormal, ComputeServiceConstants.Timeouts timeouts, ResourceIdToFirewallId toFirewallId, ResourceIdToSystemId toSystemId) {
        this.api = (FGCPApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.asyncApi = (FGCPAsyncApi)Preconditions.checkNotNull((Object)asyncApi, (Object)"asyncApi");
        this.serverStopped = new RetryablePredicate((Predicate)Preconditions.checkNotNull((Object)serverStopped), timeouts.nodeSuspended);
        this.serverCreated = new RetryablePredicate((Predicate)Preconditions.checkNotNull((Object)serverStopped), timeouts.nodeRunning);
        this.systemNormal = new RetryablePredicate((Predicate)Preconditions.checkNotNull((Object)systemNormal), timeouts.nodeTerminated);
        this.toFirewallId = (ResourceIdToFirewallId)Preconditions.checkNotNull((Object)toFirewallId, (Object)"ResourceIdToFirewallId");
        this.toSystemId = (ResourceIdToSystemId)Preconditions.checkNotNull((Object)toSystemId, (Object)"ResourceIdToSystemId");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<VServerMetadata> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        String id = this.api.getVirtualSystemApi().createServer(name, template.getHardware().getName(), template.getImage().getId(), template.getLocation().getId());
        this.serverCreated.apply((Object)id);
        this.resumeNode(id);
        VServerMetadata server = this.getNode(id);
        server.setTemplate(template);
        String user = template.getImage().getOperatingSystem().getFamily() == OsFamily.WINDOWS ? "Administrator" : "root";
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)server, id, LoginCredentials.builder().identity(user).password(server.getInitialPassword()).build());
    }

    public Iterable<ServerType> listHardwareProfiles() {
        return this.api.getVirtualDCApi().listServerTypes();
    }

    public Iterable<DiskImage> listImages() {
        return this.api.getVirtualDCApi().listDiskImages();
    }

    public DiskImage getImage(String id) {
        return this.api.getDiskImageApi().get(id);
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public VServerMetadata getNode(String id) {
        VServerMetadata.Builder builder = VServerMetadata.builder();
        builder.id(id);
        ArrayList<Object> futures = new ArrayList<Object>();
        futures.add(this.asyncApi.getVirtualServerApi().getDetails(id));
        futures.add(this.asyncApi.getVirtualServerApi().getStatus(id));
        futures.add(this.asyncApi.getVirtualServerApi().getInitialPassword(id));
        String fwId = this.toFirewallId.apply(id);
        try {
            List results = (List)Futures.successfulAsList(futures).get();
            VServerWithDetails server = (VServerWithDetails)results.get(0);
            VServerStatus status = (VServerStatus)((Object)results.get(1));
            System.out.println("getNode(" + id + ")'s getDetails: " + (Object)((Object)status) + " - " + server);
            if (server == null) {
                server = this.api.getVirtualServerApi().getDetails(id);
                System.out.println("getNode(" + id + ")'s getDetails(2) returns: " + server);
            }
            builder.serverWithDetails(server);
            builder.status(status == null ? VServerStatus.UNRECOGNIZED : status);
            builder.initialPassword((String)results.get(2));
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return builder.build();
    }

    public Iterable<VServerMetadata> listNodes() {
        ImmutableSet.Builder servers = ImmutableSet.builder();
        Set<VSystem> systems = this.api.getVirtualDCApi().listVirtualSystems();
        ArrayList<ListenableFuture<VSystemWithDetails>> futures = new ArrayList<ListenableFuture<VSystemWithDetails>>();
        for (VSystem system : systems) {
            futures.add(this.asyncApi.getVirtualSystemApi().getDetails(system.getId()));
        }
        try {
            for (VSystem system : (List)Futures.successfulAsList(futures).get()) {
                if (system == null) continue;
                for (VServerWithVNICs server : ((VSystemWithDetails)system).getServers()) {
                    if (server.getId().endsWith("-S-0001") || server.getVnics().iterator().next().getNicNo() != 0) continue;
                    servers.add((Object)this.getNode(server.getId()));
                }
            }
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return servers.build();
    }

    public void destroyNode(String id) {
        this.api.getVirtualServerApi().destroy(id);
        String systemId = this.toSystemId.apply(id);
        this.systemNormal.apply((Object)systemId);
    }

    public void rebootNode(String id) {
        this.suspendNode(id);
        this.serverStopped.apply((Object)id);
        this.resumeNode(id);
    }

    public void resumeNode(String id) {
        this.api.getVirtualServerApi().start(id);
    }

    public void suspendNode(String id) {
        this.api.getVirtualServerApi().stop(id);
    }
}

