/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute.predicates;

import com.google.common.base.Predicate;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.fujitsu.fgcp.FGCPApi;
import org.jclouds.fujitsu.fgcp.domain.VSystemStatus;
import org.jclouds.logging.Logger;

@Singleton
public class SystemStatusNormal
implements Predicate<String> {
    private final FGCPApi api;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public SystemStatusNormal(FGCPApi api) {
        this.api = api;
    }

    public boolean apply(String systemId) {
        this.logger.trace("looking for status on system %s", new Object[]{systemId});
        VSystemStatus status = this.api.getVirtualSystemApi().getStatus(systemId);
        this.logger.trace("looking for status on system %s: currently: %s", new Object[]{systemId, status});
        if (status == VSystemStatus.ERROR) {
            throw new IllegalStateException("system in error: " + (Object)((Object)status));
        }
        return status == VSystemStatus.NORMAL;
    }
}

