/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute.predicates;

import com.google.common.base.Predicate;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.fujitsu.fgcp.FGCPApi;
import org.jclouds.fujitsu.fgcp.domain.VServerStatus;
import org.jclouds.logging.Logger;

@Singleton
public class ServerStopped
implements Predicate<String> {
    private final FGCPApi api;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public ServerStopped(FGCPApi api) {
        this.api = api;
    }

    public boolean apply(String serverId) {
        this.logger.trace("looking for status on server %s", new Object[]{serverId});
        VServerStatus status = this.api.getVirtualServerApi().getStatus(serverId);
        this.logger.trace("looking for status on server %s: currently: %s", new Object[]{serverId, status});
        if (status == VServerStatus.ERROR || status == VServerStatus.STOP_ERROR) {
            throw new IllegalStateException("server not around or in error: " + (Object)((Object)status));
        }
        return status == VServerStatus.STOPPED;
    }
}

