/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.fujitsu.fgcp.compute.strategy.VServerMetadata;
import org.jclouds.fujitsu.fgcp.domain.VNIC;
import org.jclouds.fujitsu.fgcp.domain.VServer;
import org.jclouds.fujitsu.fgcp.domain.VServerStatus;
import org.jclouds.fujitsu.fgcp.domain.VServerWithVNICs;
import org.jclouds.logging.Logger;

@Singleton
public class VServerMetadataToNodeMetadata
implements Function<VServerMetadata, NodeMetadata> {
    public static final Map<VServerStatus, NodeMetadata.Status> vServerToStatus = ImmutableMap.builder().put((Object)VServerStatus.DEPLOYING, (Object)NodeMetadata.Status.PENDING).put((Object)VServerStatus.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)VServerStatus.STOPPING, (Object)NodeMetadata.Status.PENDING).put((Object)VServerStatus.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)VServerStatus.STARTING, (Object)NodeMetadata.Status.PENDING).put((Object)VServerStatus.FAILOVER, (Object)NodeMetadata.Status.RUNNING).put((Object)VServerStatus.UNEXPECTED_STOP, (Object)NodeMetadata.Status.SUSPENDED).put((Object)VServerStatus.RESTORING, (Object)NodeMetadata.Status.PENDING).put((Object)VServerStatus.BACKUP_ING, (Object)NodeMetadata.Status.PENDING).put((Object)VServerStatus.ERROR, (Object)NodeMetadata.Status.ERROR).put((Object)VServerStatus.START_ERROR, (Object)NodeMetadata.Status.ERROR).put((Object)VServerStatus.STOP_ERROR, (Object)NodeMetadata.Status.ERROR).put((Object)VServerStatus.CHANGE_TYPE, (Object)NodeMetadata.Status.PENDING).put((Object)VServerStatus.REGISTERING, (Object)NodeMetadata.Status.PENDING).put((Object)VServerStatus.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Set<? extends Location>> locations;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final GroupNamingConvention nodeNamingConvention;

    protected Image parseImage(VServer from) {
        try {
            return (Image)Iterables.find((Iterable)((Iterable)this.images.get()), (Predicate)new FindImageForVServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching image for server %s", new Object[]{from});
            return null;
        }
    }

    protected Hardware parseHardware(String from) {
        try {
            return (Hardware)Iterables.find((Iterable)((Iterable)this.hardwares.get()), (Predicate)new FindHardwareForServerType(from));
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching hardware for server type %s", new Object[]{from});
            return null;
        }
    }

    protected Location parseLocation(VServerWithVNICs from) {
        try {
            return (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new FindLocationForVServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching realm for server %s", new Object[]{from});
            return null;
        }
    }

    @Inject
    VServerMetadataToNodeMetadata(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, GroupNamingConvention.Factory namingConvention) {
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares");
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
    }

    public NodeMetadata apply(VServerMetadata from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId());
        builder.name(from.getName());
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getName()));
        if (from.getStatus() == null) {
            System.out.println("status null for: " + from.getId() + ": " + from.getName());
        }
        builder.status(vServerToStatus.get((Object)from.getStatus()));
        builder.privateAddresses((Iterable)ImmutableSet.of());
        builder.publicAddresses((Iterable)ImmutableSet.of());
        if (from.getServer() != null) {
            builder.imageId(from.getServer().getDiskimageId());
            builder.hardware(this.parseHardware(from.getServer().getType()));
            LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder().password(from.getInitialPassword());
            Image image = this.parseImage(from.getServer());
            if (image != null) {
                builder.operatingSystem(image.getOperatingSystem());
                String user = image.getDefaultCredentials().getUser();
                credentialsBuilder.identity(user);
            }
            builder.credentials(credentialsBuilder.build());
            if (from.getServer() instanceof VServerWithVNICs) {
                VServerWithVNICs server = (VServerWithVNICs)from.getServer();
                builder.location(this.parseLocation(server));
                ArrayList<String> ips = new ArrayList<String>();
                if (server.getVnics() != null && server.getVnics().iterator().next().getPrivateIp() != null) {
                    ips.add(server.getVnics().iterator().next().getPrivateIp());
                }
                builder.privateAddresses(ips);
            }
        }
        if (from.getTemplate() != null) {
            builder.location(from.getTemplate().getLocation());
        }
        return builder.build();
    }

    private static class FindLocationForVServer
    implements Predicate<Location> {
        private final VServerWithVNICs server;

        private FindLocationForVServer(VServerWithVNICs server) {
            this.server = server;
        }

        public boolean apply(Location input) {
            return input.getId().equals(((VNIC)Iterables.getLast(this.server.getVnics())).getNetworkId());
        }
    }

    private static class FindHardwareForServerType
    implements Predicate<Hardware> {
        private final String type;

        private FindHardwareForServerType(String type) {
            this.type = type;
        }

        public boolean apply(Hardware input) {
            return input.getName().equals(this.type);
        }
    }

    private static class FindImageForVServer
    implements Predicate<Image> {
        private final VServer server;

        private FindImageForVServer(VServer server) {
            this.server = server;
        }

        public boolean apply(Image input) {
            return input.getId().equals(this.server.getDiskimageId());
        }
    }
}

