/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.fujitsu.fgcp.compute.functions.CPUToProcessor;
import org.jclouds.fujitsu.fgcp.compute.functions.DiskToVolume;
import org.jclouds.fujitsu.fgcp.domain.ServerType;

@Singleton
public class ServerTypeToHardware
implements Function<ServerType, Hardware> {
    private final CPUToProcessor cpuToProcessor;
    private final DiskToVolume diskToVolume;

    @Inject
    public ServerTypeToHardware(CPUToProcessor cpuToProcessor, DiskToVolume diskToVolume) {
        this.cpuToProcessor = (CPUToProcessor)Preconditions.checkNotNull((Object)cpuToProcessor);
        this.diskToVolume = (DiskToVolume)Preconditions.checkNotNull((Object)diskToVolume);
    }

    public Hardware apply(ServerType from) {
        Preconditions.checkNotNull((Object)from, (Object)"ServerType");
        HardwareBuilder builder = new HardwareBuilder();
        builder.ids(from.getId());
        builder.name(from.getName());
        builder.ram((int)(1000.0 * Double.valueOf(from.getMemory().getSize())));
        builder.processor(this.cpuToProcessor.apply(from.getCpu()));
        builder.supportsImage(Predicates.alwaysTrue());
        builder.is64Bit(true);
        builder.volumes(Iterables.transform(from.getDisks(), (Function)this.diskToVolume));
        return builder.build();
    }
}

