/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.fujitsu.fgcp.domain.Disk;

@Singleton
public class DiskToVolume
implements Function<Disk, Volume> {
    public Volume apply(Disk disk) {
        Preconditions.checkNotNull((Object)disk, (Object)"disk");
        VolumeBuilder builder = new VolumeBuilder();
        builder.size(Float.valueOf(1000.0f * Float.valueOf(disk.getSize()).floatValue()));
        builder.bootDevice(false);
        builder.durable(true);
        builder.type(Volume.Type.SAN);
        builder.id("type: " + disk.getType() + " usage: " + disk.getUsage());
        return builder.build();
    }
}

