/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.fujitsu.fgcp.domain.DiskImage;

@Singleton
public class DiskImageToOperatingSystem
implements Function<DiskImage, OperatingSystem> {
    private static final Pattern OS_VERSION_PATTERN = Pattern.compile("^.*?(\\d.*)\\s(32|64).*$");

    public OperatingSystem apply(DiskImage image) {
        Preconditions.checkNotNull((Object)image, (Object)"disk image");
        String shortOsName = image.getOsName().replace("Red Hat Enterprise Linux", "rhel");
        OsFamily osFamily = ComputeServiceUtils.parseOsFamilyOrUnrecognized((String)shortOsName);
        OperatingSystem.Builder builder = OperatingSystem.builder();
        builder.name(image.getOsName());
        builder.family(osFamily);
        builder.is64Bit(image.getOsName().contains("64bit") || image.getOsName().contains("64 bit") || image.getOsName().contains("x64"));
        builder.arch(image.getOsType());
        Matcher m = OS_VERSION_PATTERN.matcher(image.getOsName());
        if (m.matches()) {
            builder.version(m.group(1));
        }
        builder.description(image.getOsName());
        return builder.build();
    }
}

