/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.fujitsu.fgcp.compute.functions.DiskImageToOperatingSystem;
import org.jclouds.fujitsu.fgcp.domain.DiskImage;
import org.jclouds.location.suppliers.all.RegionToProviderOrJustProvider;

@Singleton
public class DiskImageToImage
implements Function<DiskImage, Image> {
    private final DiskImageToOperatingSystem diskImageToOperatingSystem;
    private final RegionToProviderOrJustProvider regionSupplier;

    @Inject
    public DiskImageToImage(DiskImageToOperatingSystem diskImageToOperatingSystem, RegionToProviderOrJustProvider locationSupplier) {
        this.diskImageToOperatingSystem = (DiskImageToOperatingSystem)Preconditions.checkNotNull((Object)diskImageToOperatingSystem, (Object)"diskImageToOperatingSystem");
        this.regionSupplier = (RegionToProviderOrJustProvider)Preconditions.checkNotNull((Object)locationSupplier, (Object)"locationProvider");
    }

    public Image apply(DiskImage from) {
        Preconditions.checkNotNull((Object)from, (Object)"disk image");
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.getId());
        builder.name(from.getName());
        builder.description(from.getDescription());
        builder.location((Location)Iterables.getOnlyElement((Iterable)this.regionSupplier.get()));
        builder.status(Image.Status.AVAILABLE);
        OperatingSystem os = this.diskImageToOperatingSystem.apply(from);
        builder.operatingSystem(os);
        String user = os.getFamily() == OsFamily.WINDOWS ? "Administrator" : "root";
        builder.defaultCredentials(LoginCredentials.builder().identity(user).noPassword().build());
        return builder.build();
    }
}

