/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.compute;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.InputSupplier;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.date.TimeStamp;
import org.jclouds.fujitsu.fgcp.FGCPApi;
import org.jclouds.fujitsu.fgcp.FGCPAsyncApi;
import org.jclouds.fujitsu.fgcp.handlers.FGCPRetryIfNotProxyAuthenticationFailureHandler;
import org.jclouds.fujitsu.fgcp.http.SSLContextWithKeysSupplier;
import org.jclouds.fujitsu.fgcp.location.SystemAndNetworkSegmentToLocationSupplier;
import org.jclouds.fujitsu.fgcp.services.AdditionalDiskApi;
import org.jclouds.fujitsu.fgcp.services.AdditionalDiskAsyncApi;
import org.jclouds.fujitsu.fgcp.services.BuiltinServerApi;
import org.jclouds.fujitsu.fgcp.services.BuiltinServerAsyncApi;
import org.jclouds.fujitsu.fgcp.services.DiskImageApi;
import org.jclouds.fujitsu.fgcp.services.DiskImageAsyncApi;
import org.jclouds.fujitsu.fgcp.services.FirewallApi;
import org.jclouds.fujitsu.fgcp.services.FirewallAsyncApi;
import org.jclouds.fujitsu.fgcp.services.LoadBalancerApi;
import org.jclouds.fujitsu.fgcp.services.LoadBalancerAsyncApi;
import org.jclouds.fujitsu.fgcp.services.PublicIPAddressApi;
import org.jclouds.fujitsu.fgcp.services.PublicIPAddressAsyncApi;
import org.jclouds.fujitsu.fgcp.services.SystemTemplateApi;
import org.jclouds.fujitsu.fgcp.services.SystemTemplateAsyncApi;
import org.jclouds.fujitsu.fgcp.services.VirtualDCApi;
import org.jclouds.fujitsu.fgcp.services.VirtualDCAsyncApi;
import org.jclouds.fujitsu.fgcp.services.VirtualServerApi;
import org.jclouds.fujitsu.fgcp.services.VirtualServerAsyncApi;
import org.jclouds.fujitsu.fgcp.services.VirtualSystemApi;
import org.jclouds.fujitsu.fgcp.services.VirtualSystemAsyncApi;
import org.jclouds.fujitsu.fgcp.xml.FGCPJAXBParser;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.io.InputSuppliers;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.implicit.FirstNetwork;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.xml.XMLParser;

@ConfiguresRestClient
public class FGCPRestClientModule
extends RestClientModule<FGCPApi, FGCPAsyncApi> {
    @Resource
    Logger logger = Logger.NULL;
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(VirtualDCApi.class, VirtualDCAsyncApi.class).put(VirtualSystemApi.class, VirtualSystemAsyncApi.class).put(VirtualServerApi.class, VirtualServerAsyncApi.class).put(AdditionalDiskApi.class, AdditionalDiskAsyncApi.class).put(SystemTemplateApi.class, SystemTemplateAsyncApi.class).put(DiskImageApi.class, DiskImageAsyncApi.class).put(BuiltinServerApi.class, BuiltinServerAsyncApi.class).put(FirewallApi.class, FirewallAsyncApi.class).put(LoadBalancerApi.class, LoadBalancerAsyncApi.class).put(PublicIPAddressApi.class, PublicIPAddressAsyncApi.class).build();

    public FGCPRestClientModule() {
        super(DELEGATE_MAP);
    }

    protected void bindErrorHandlers() {
    }

    protected void installLocations() {
        super.installLocations();
        this.bind(ImplicitLocationSupplier.class).to(FirstNetwork.class).in(Scopes.SINGLETON);
        this.bind(LocationsSupplier.class).to(SystemAndNetworkSegmentToLocationSupplier.class).in(Scopes.SINGLETON);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(FGCPRetryIfNotProxyAuthenticationFailureHandler.class);
    }

    protected void configure() {
        super.configure();
        this.bind(XMLParser.class).to(FGCPJAXBParser.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<SSLContext>>(){}).to((TypeLiteral)new TypeLiteral<SSLContextWithKeysSupplier>(){});
    }

    @Provides
    @TimeStamp
    protected Calendar provideCalendar() {
        return Calendar.getInstance();
    }

    @Provides
    @Singleton
    protected KeyStore provideKeyStore(Crypto crypto, @Identity String cert, @Credential String keyStorePassword) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            File certFile = new File((String)Preconditions.checkNotNull((Object)cert));
            if (certFile.isFile()) {
                keyStore.load(new FileInputStream(certFile), keyStorePassword.toCharArray());
            } else {
                int privateKeyBeginIdx = cert.indexOf("-----BEGIN PRIVATE KEY");
                int privateKeyEndIdx = cert.indexOf("-----END PRIVATE KEY");
                String pemPrivateKey = cert.substring(privateKeyBeginIdx, privateKeyEndIdx + 26);
                String pemCerts = "";
                int certsBeginIdx = 0;
                do {
                    if ((certsBeginIdx = cert.indexOf("-----BEGIN CERTIFICATE", certsBeginIdx)) < 0) continue;
                    int certsEndIdx = cert.indexOf("-----END CERTIFICATE", certsBeginIdx) + 26;
                    pemCerts = pemCerts + cert.substring(certsBeginIdx, certsEndIdx);
                    certsBeginIdx = certsEndIdx;
                } while (certsBeginIdx != -1);
                KeySpec keySpec = Pems.privateKeySpec((InputSupplier)InputSuppliers.of((String)pemPrivateKey));
                PrivateKey privateKey = crypto.rsaKeyFactory().generatePrivate(keySpec);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certs = cf.generateCertificates(new ByteArrayInputStream(pemCerts.getBytes("UTF-8")));
                keyStore.load(null);
                keyStore.setKeyEntry("dummy", privateKey, keyStorePassword.toCharArray(), certs.toArray(new Certificate[0]));
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("Error loading certificate", (Throwable)e);
        }
        return keyStore;
    }
}

