/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp.binders;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindAlsoToSystemId
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkArgument((boolean)(input instanceof String), (Object)("this binder only applies to String arguments: " + input.getClass()));
        Pattern pattern = Pattern.compile("^(\\w+-\\w+)\\b.*");
        Matcher matcher = pattern.matcher((String)input);
        Preconditions.checkArgument((boolean)matcher.find(), (Object)("no valid resource id found to construct vsys id from: " + input.toString()));
        HttpRequest.Builder builder = request.toBuilder();
        builder.replaceQueryParam("vsysId", new String[]{matcher.group(1)});
        return (R)builder.build();
    }
}

