/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fujitsu.fgcp;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.fujitsu.fgcp.FGCPApi;
import org.jclouds.fujitsu.fgcp.FGCPAsyncApi;
import org.jclouds.fujitsu.fgcp.compute.FGCPRestClientModule;
import org.jclouds.fujitsu.fgcp.compute.config.FGCPComputeServiceContextModule;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class FGCPApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = -8430912756058292588L;

    public Builder toBuilder() {
        return new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public FGCPApiMetadata() {
        this(new Builder());
    }

    protected FGCPApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.trust-all-certs", "false");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(FGCPApi.class, FGCPAsyncApi.class);
            this.id("fgcp").name("Fujitsu Global Cloud Platform (FGCP)").identityName("User certificate (PEM file)").credentialName("User certificate password").documentation(URI.create("https://globalcloud.fujitsu.com.au/portala/ctrl/aboutSopManual")).version("2012-02-18").defaultEndpoint("https://api.globalcloud.fujitsu.com.au/ovissapi/endpoint").defaultProperties(FGCPApiMetadata.defaultProperties()).view(TypeToken.of(ComputeServiceContext.class)).defaultModules((Set)ImmutableSet.of(FGCPComputeServiceContextModule.class, FGCPRestClientModule.class));
        }

        public FGCPApiMetadata build() {
            return new FGCPApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

