/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.test.config;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.io.InputSupplier;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.LocalAsyncBlobStore;
import org.jclouds.blobstore.TransientApiMetadata;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefAsyncApi;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.functions.ClientForGroup;
import org.jclouds.chef.functions.RunListForGroup;
import org.jclouds.chef.statements.InstallChefGems;
import org.jclouds.chef.test.TransientChefApi;
import org.jclouds.chef.test.TransientChefAsyncApi;
import org.jclouds.concurrent.MoreExecutors;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.io.InputSuppliers;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.RestModule;
import org.jclouds.scriptbuilder.domain.Statement;

@ConfiguresRestClient
public class TransientChefApiModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new RestModule());
        this.bind(ChefAsyncApi.class).to(TransientChefAsyncApi.class).asEagerSingleton();
        BinderUtils.bindClient((Binder)this.binder(), TransientChefApi.class, ChefAsyncApi.class, (Map)ImmutableMap.of());
        this.bind(ChefApi.class).to(TransientChefApi.class);
        this.bind(LocalAsyncBlobStore.class).annotatedWith((Annotation)Names.named((String)"databags")).toInstance(ContextBuilder.newBuilder((ApiMetadata)new TransientApiMetadata()).modules((Iterable)ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()))).buildInjector().getInstance(LocalAsyncBlobStore.class));
        this.bind(Statement.class).annotatedWith((Annotation)Names.named((String)"installChefGems")).to(InstallChefGems.class);
    }

    @Provides
    @Singleton
    public PrivateKey provideKey(Crypto crypto, @Credential String pem) throws InvalidKeySpecException, IOException {
        return crypto.rsaKeyFactory().generatePrivate(Pems.privateKeySpec((InputSupplier)InputSuppliers.of((String)pem)));
    }

    @Provides
    @Singleton
    Map<String, List<String>> runListForTag(RunListForGroup runListForTag) {
        return new MapMaker().makeComputingMap((Function)runListForTag);
    }

    @Provides
    @Singleton
    Map<String, Client> tagToClient(ClientForGroup tagToClient) {
        return new MapMaker().makeComputingMap((Function)tagToClient);
    }
}

