/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.test;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.LocalAsyncBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.chef.ChefAsyncApi;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.domain.Resource;
import org.jclouds.chef.domain.Role;
import org.jclouds.chef.domain.Sandbox;
import org.jclouds.chef.domain.SearchResult;
import org.jclouds.chef.domain.UploadSandbox;
import org.jclouds.chef.options.CreateClientOptions;
import org.jclouds.chef.options.SearchOptions;
import org.jclouds.concurrent.Futures;
import org.jclouds.io.Payload;
import org.jclouds.util.Strings2;

public class TransientChefAsyncApi
implements ChefAsyncApi {
    private final LocalAsyncBlobStore databags;
    private final ExecutorService executor;
    private final BlobToDatabagItem blobToDatabagItem;
    private final StorageMetadataToName storageMetadataToName;

    @Inject
    TransientChefAsyncApi(@Named(value="databags") LocalAsyncBlobStore databags, StorageMetadataToName storageMetadataToName, BlobToDatabagItem blobToDatabagItem, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.databags = (LocalAsyncBlobStore)Preconditions.checkNotNull((Object)databags, (Object)"databags");
        this.storageMetadataToName = (StorageMetadataToName)Preconditions.checkNotNull((Object)storageMetadataToName, (Object)"storageMetadataToName");
        this.blobToDatabagItem = (BlobToDatabagItem)Preconditions.checkNotNull((Object)blobToDatabagItem, (Object)"blobToDatabagItem");
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    @Override
    public ListenableFuture<Boolean> clientExists(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Sandbox> commitSandbox(String id, boolean isCompleted) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Client> createClient(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Client> createClient(String clientname, CreateClientOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Void> createDatabag(String databagName) {
        return com.google.common.util.concurrent.Futures.transform((ListenableFuture)this.databags.createContainerInLocation(null, databagName), (Function)new Function<Boolean, Void>(){

            public Void apply(Boolean input) {
                return null;
            }
        });
    }

    @Override
    public ListenableFuture<DatabagItem> createDatabagItem(String databagName, DatabagItem databagItem) {
        Blob blob = this.databags.blobBuilder(databagItem.getId()).payload(databagItem.toString()).build();
        this.databags.putBlob(databagName, blob);
        return com.google.common.util.concurrent.Futures.immediateFuture((Object)((Object)databagItem));
    }

    @Override
    public ListenableFuture<Void> createNode(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Void> createRole(Role role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Boolean> databagExists(String databagName) {
        return this.databags.containerExists(databagName);
    }

    @Override
    public ListenableFuture<Boolean> databagItemExists(String databagName, String databagItemId) {
        return this.databags.blobExists(databagName, databagItemId);
    }

    @Override
    public ListenableFuture<Client> deleteClient(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<CookbookVersion> deleteCookbook(String cookbookName, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Void> deleteDatabag(String databagName) {
        return this.databags.deleteContainer(databagName);
    }

    @Override
    public ListenableFuture<DatabagItem> deleteDatabagItem(String databagName, String databagItemId) {
        return com.google.common.util.concurrent.Futures.immediateFuture((Object)((Object)this.blobToDatabagItem.apply((Blob)this.databags.getContext().createBlobMap(databagName).remove((Object)databagItemId))));
    }

    @Override
    public ListenableFuture<Node> deleteNode(String nodename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Role> deleteRole(String rolename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Client> generateKeyForClient(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Client> getClient(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<CookbookVersion> getCookbook(String cookbookName, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<DatabagItem> getDatabagItem(String databagName, String databagItemId) {
        return Futures.compose((Future)this.databags.getBlob(databagName, databagItemId), (Function)this.blobToDatabagItem, (ExecutorService)this.executor);
    }

    @Override
    public ListenableFuture<Node> getNode(String nodename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Role> getRole(String rolename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<UploadSandbox> getUploadSandboxForChecksums(Set<List<Byte>> md5s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Set<String>> getVersionsOfCookbook(String cookbookName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Set<String>> listClients() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Set<String>> listCookbooks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Set<String>> listDatabagItems(String databagName) {
        return Futures.compose((Future)this.databags.list(databagName), (Function)this.storageMetadataToName, (ExecutorService)this.executor);
    }

    @Override
    public ListenableFuture<Set<String>> listDatabags() {
        return Futures.compose((Future)this.databags.list(), (Function)this.storageMetadataToName, (ExecutorService)this.executor);
    }

    @Override
    public ListenableFuture<Set<String>> listNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Set<String>> listRoles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Set<String>> listSearchIndexes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Boolean> nodeExists(String nodename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Boolean> roleExists(String rolename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<? extends SearchResult<? extends Client>> searchClients() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<? extends SearchResult<? extends Client>> searchClients(SearchOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<? extends SearchResult<? extends DatabagItem>> searchDatabag(String databagName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<? extends SearchResult<? extends DatabagItem>> searchDatabag(String databagName, SearchOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<? extends SearchResult<? extends Node>> searchNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<? extends SearchResult<? extends Node>> searchNodes(SearchOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<? extends SearchResult<? extends Role>> searchRoles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<? extends SearchResult<? extends Role>> searchRoles(SearchOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<CookbookVersion> updateCookbook(String cookbookName, String version, CookbookVersion cookbook) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<DatabagItem> updateDatabagItem(String databagName, DatabagItem item) {
        return this.createDatabagItem(databagName, item);
    }

    @Override
    public ListenableFuture<Node> updateNode(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Role> updateRole(Role role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Void> uploadContent(URI location, Payload content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<InputStream> getResourceContents(Resource resource) {
        throw new UnsupportedOperationException();
    }

    @Singleton
    private static class BlobToDatabagItem
    implements Function<Blob, DatabagItem> {
        private BlobToDatabagItem() {
        }

        public DatabagItem apply(Blob from) {
            try {
                return from == null ? null : new DatabagItem(from.getMetadata().getName(), Strings2.toStringAndClose((InputStream)from.getPayload().getInput()));
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    @Singleton
    private static class StorageMetadataToName
    implements Function<PageSet<? extends StorageMetadata>, Set<String>> {
        private StorageMetadataToName() {
        }

        public Set<String> apply(PageSet<? extends StorageMetadata> from) {
            return Sets.newLinkedHashSet((Iterable)Iterables.transform(from, (Function)new Function<StorageMetadata, String>(){

                public String apply(StorageMetadata from) {
                    return from.getName();
                }
            }));
        }
    }
}

