/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefAsyncApi;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.strategy.ListNodes;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;

@Singleton
public class ListNodesImpl
implements ListNodes {
    protected final ChefApi chefApi;
    protected final ChefAsyncApi chefAsyncApi;
    protected final ExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    ListNodesImpl(@Named(value="jclouds.user-threads") ExecutorService userExecutor, ChefApi getAllNode, ChefAsyncApi ablobstore) {
        this.userExecutor = userExecutor;
        this.chefAsyncApi = ablobstore;
        this.chefApi = getAllNode;
    }

    @Override
    public Iterable<? extends Node> execute() {
        return this.execute(this.chefApi.listNodes());
    }

    @Override
    public Iterable<? extends Node> execute(Predicate<String> nodeNameSelector) {
        return this.execute(Iterables.filter(this.chefApi.listNodes(), nodeNameSelector));
    }

    @Override
    public Iterable<? extends Node> execute(Iterable<String> toGet) {
        return FutureIterables.transformParallel(toGet, (Function)new Function<String, Future<? extends Node>>(){

            public Future<Node> apply(String from) {
                return ListNodesImpl.this.chefAsyncApi.getNode(from);
            }
        }, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)"getting nodes");
    }
}

