/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefAsyncApi;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.strategy.ListCookbookVersions;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;

@Singleton
public class ListCookbookVersionsImpl
implements ListCookbookVersions {
    protected final ChefApi chefApi;
    protected final ChefAsyncApi chefAsyncApi;
    protected final ExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    ListCookbookVersionsImpl(@Named(value="jclouds.user-threads") ExecutorService userExecutor, ChefApi getAllCookbookVersion, ChefAsyncApi ablobstore) {
        this.userExecutor = userExecutor;
        this.chefAsyncApi = ablobstore;
        this.chefApi = getAllCookbookVersion;
    }

    @Override
    public Iterable<? extends CookbookVersion> execute() {
        return this.execute(this.chefApi.listCookbooks());
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(Predicate<String> cookbookNameSelector) {
        return this.execute(Iterables.filter(this.chefApi.listCookbooks(), cookbookNameSelector));
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(Iterable<String> toGet) {
        return Iterables.concat((Iterable)Iterables.transform(toGet, (Function)new Function<String, Iterable<? extends CookbookVersion>>(){

            public Iterable<? extends CookbookVersion> apply(final String cookbook) {
                return FutureIterables.transformParallel(ListCookbookVersionsImpl.this.chefApi.getVersionsOfCookbook(cookbook), (Function)new Function<String, Future<? extends CookbookVersion>>(){

                    public Future<CookbookVersion> apply(String version) {
                        return ListCookbookVersionsImpl.this.chefAsyncApi.getCookbook(cookbook, version);
                    }
                }, (ExecutorService)ListCookbookVersionsImpl.this.userExecutor, (Long)ListCookbookVersionsImpl.this.maxTime, (Logger)ListCookbookVersionsImpl.this.logger, (String)("getting versions of cookbook " + cookbook));
            }
        }));
    }
}

