/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefAsyncApi;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.strategy.ListClients;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;

@Singleton
public class ListClientsImpl
implements ListClients {
    protected final ChefApi chefApi;
    protected final ChefAsyncApi chefAsyncApi;
    protected final ExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    ListClientsImpl(@Named(value="jclouds.user-threads") ExecutorService userExecutor, ChefApi getAllApi, ChefAsyncApi ablobstore) {
        this.userExecutor = userExecutor;
        this.chefAsyncApi = ablobstore;
        this.chefApi = getAllApi;
    }

    @Override
    public Iterable<? extends Client> execute() {
        return this.execute(this.chefApi.listClients());
    }

    @Override
    public Iterable<? extends Client> execute(Predicate<String> clientNameSelector) {
        return this.execute(Iterables.filter(this.chefApi.listClients(), clientNameSelector));
    }

    @Override
    public Iterable<? extends Client> execute(Iterable<String> toGet) {
        return FutureIterables.transformParallel(toGet, (Function)new Function<String, Future<? extends Client>>(){

            public Future<Client> apply(String from) {
                return ListClientsImpl.this.chefAsyncApi.getClient(from);
            }
        }, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)"getting apis");
    }
}

