/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefAsyncApi;
import org.jclouds.chef.strategy.DeleteAllClientsInList;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;

@Singleton
public class DeleteAllClientsInListImpl
implements DeleteAllClientsInList {
    protected final ChefApi chefApi;
    protected final ChefAsyncApi chefAsyncApi;
    protected final ExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    DeleteAllClientsInListImpl(@Named(value="jclouds.user-threads") ExecutorService userExecutor, ChefApi getAllApi, ChefAsyncApi ablobstore) {
        this.userExecutor = userExecutor;
        this.chefAsyncApi = ablobstore;
        this.chefApi = getAllApi;
    }

    @Override
    public void execute(Iterable<String> names) {
        Map exceptions = Maps.newHashMap();
        HashMap responses = Maps.newHashMap();
        for (String name : names) {
            responses.put(name, this.chefAsyncApi.deleteClient(name));
        }
        try {
            exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)String.format("deleting apis: %s", names));
        }
        catch (TimeoutException e) {
            Throwables.propagate((Throwable)e);
        }
        if (exceptions.size() > 0) {
            throw new RuntimeException(String.format("errors deleting clients: %s: %s", names, exceptions));
        }
    }
}

