/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefContext;
import org.jclouds.chef.ChefService;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.functions.GroupToBootScript;
import org.jclouds.chef.functions.RunListForGroup;
import org.jclouds.chef.strategy.CleanupStaleNodesAndClients;
import org.jclouds.chef.strategy.CreateNodeAndPopulateAutomaticAttributes;
import org.jclouds.chef.strategy.DeleteAllClientsInList;
import org.jclouds.chef.strategy.DeleteAllNodesInList;
import org.jclouds.chef.strategy.ListClients;
import org.jclouds.chef.strategy.ListCookbookVersions;
import org.jclouds.chef.strategy.ListNodes;
import org.jclouds.chef.strategy.UpdateAutomaticAttributesOnNode;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.RSADecryptingPayload;
import org.jclouds.io.payloads.RSAEncryptingPayload;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;

@Singleton
public class BaseChefService
implements ChefService {
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;
    private final ChefContext chefContext;
    private final CleanupStaleNodesAndClients cleanupStaleNodesAndClients;
    private final CreateNodeAndPopulateAutomaticAttributes createNodeAndPopulateAutomaticAttributes;
    private final DeleteAllNodesInList deleteAllNodesInList;
    private final ListNodes listNodes;
    private final DeleteAllClientsInList deleteAllClientsInList;
    private final ListClients listClients;
    private final UpdateAutomaticAttributesOnNode updateAutomaticAttributesOnNode;
    private final Provider<PrivateKey> privateKey;
    private final GroupToBootScript groupToBootScript;
    private final String databag;
    private final RunListForGroup runListForGroup;
    private final ListCookbookVersions listCookbookVersions;

    @Inject
    protected BaseChefService(ChefContext chefContext, CleanupStaleNodesAndClients cleanupStaleNodesAndClients, CreateNodeAndPopulateAutomaticAttributes createNodeAndPopulateAutomaticAttributes, DeleteAllNodesInList deleteAllNodesInList, ListNodes listNodes, DeleteAllClientsInList deleteAllClientsInList, ListClients listClients, ListCookbookVersions listCookbookVersions, UpdateAutomaticAttributesOnNode updateAutomaticAttributesOnNode, Provider<PrivateKey> privateKey, @Named(value="chef.bootstrap-databag") String databag, GroupToBootScript groupToBootScript, RunListForGroup runListForGroup) {
        this.chefContext = (ChefContext)Preconditions.checkNotNull((Object)chefContext, (Object)"chefContext");
        this.cleanupStaleNodesAndClients = (CleanupStaleNodesAndClients)Preconditions.checkNotNull((Object)cleanupStaleNodesAndClients, (Object)"cleanupStaleNodesAndClients");
        this.createNodeAndPopulateAutomaticAttributes = (CreateNodeAndPopulateAutomaticAttributes)Preconditions.checkNotNull((Object)createNodeAndPopulateAutomaticAttributes, (Object)"createNodeAndPopulateAutomaticAttributes");
        this.deleteAllNodesInList = (DeleteAllNodesInList)Preconditions.checkNotNull((Object)deleteAllNodesInList, (Object)"deleteAllNodesInList");
        this.listNodes = (ListNodes)Preconditions.checkNotNull((Object)listNodes, (Object)"listNodes");
        this.deleteAllClientsInList = (DeleteAllClientsInList)Preconditions.checkNotNull((Object)deleteAllClientsInList, (Object)"deleteAllClientsInList");
        this.listClients = (ListClients)Preconditions.checkNotNull((Object)listClients, (Object)"listClients");
        this.listCookbookVersions = (ListCookbookVersions)Preconditions.checkNotNull((Object)listCookbookVersions, (Object)"listCookbookVersions");
        this.updateAutomaticAttributesOnNode = (UpdateAutomaticAttributesOnNode)Preconditions.checkNotNull((Object)updateAutomaticAttributesOnNode, (Object)"updateAutomaticAttributesOnNode");
        this.privateKey = (Provider)Preconditions.checkNotNull(privateKey, (Object)"privateKey");
        this.groupToBootScript = (GroupToBootScript)Preconditions.checkNotNull((Object)groupToBootScript, (Object)"groupToBootScript");
        this.databag = (String)Preconditions.checkNotNull((Object)databag, (Object)"databag");
        this.runListForGroup = (RunListForGroup)Preconditions.checkNotNull((Object)runListForGroup, (Object)"runListForGroup");
    }

    @Override
    public void cleanupStaleNodesAndClients(String prefix, int secondsStale) {
        this.cleanupStaleNodesAndClients.execute(prefix, secondsStale);
    }

    @Override
    public Node createNodeAndPopulateAutomaticAttributes(String nodeName, Iterable<String> runList) {
        return this.createNodeAndPopulateAutomaticAttributes.execute(nodeName, runList);
    }

    @Override
    public void deleteAllNodesInList(Iterable<String> names) {
        this.deleteAllNodesInList.execute(names);
    }

    @Override
    public Iterable<? extends Node> listNodes() {
        return this.listNodes.execute();
    }

    @Override
    public Iterable<? extends Node> listNodesMatching(Predicate<String> nodeNameSelector) {
        return this.listNodes.execute(nodeNameSelector);
    }

    @Override
    public Iterable<? extends Node> listNodesNamed(Iterable<String> names) {
        return this.listNodes.execute(names);
    }

    @Override
    public void deleteAllClientsInList(Iterable<String> names) {
        this.deleteAllClientsInList.execute(names);
    }

    @Override
    public Iterable<? extends Client> listClientsDetails() {
        return this.listClients.execute();
    }

    @Override
    public Iterable<? extends Client> listClientsDetailsMatching(Predicate<String> clientNameSelector) {
        return this.listClients.execute(clientNameSelector);
    }

    @Override
    public Iterable<? extends Client> listClientsNamed(Iterable<String> names) {
        return this.listClients.execute(names);
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersions() {
        return this.listCookbookVersions.execute();
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersionsMatching(Predicate<String> cookbookNameSelector) {
        return this.listCookbookVersions.execute(cookbookNameSelector);
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersionsNamed(Iterable<String> names) {
        return this.listCookbookVersions.execute(names);
    }

    @Override
    public void updateAutomaticAttributesOnNode(String nodeName) {
        this.updateAutomaticAttributesOnNode.execute(nodeName);
    }

    @Override
    public ChefContext getContext() {
        return this.chefContext;
    }

    @Override
    public Statement createBootstrapScriptForGroup(String group) {
        return this.groupToBootScript.apply(group);
    }

    @Override
    public void updateRunListForGroup(Iterable<String> runList, String group) {
        try {
            ((ChefApi)this.chefContext.getApi()).createDatabag(this.databag);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        DatabagItem runlist = new DatabagItem(group, this.chefContext.utils().json().toJson((Object)ImmutableMap.of((Object)"run_list", (Object)Lists.newArrayList(runList)), RunListForGroup.RUN_LIST_TYPE));
        if (((ChefApi)this.chefContext.getApi()).getDatabagItem(this.databag, group) == null) {
            ((ChefApi)this.chefContext.getApi()).createDatabagItem(this.databag, runlist);
        } else {
            ((ChefApi)this.chefContext.getApi()).updateDatabagItem(this.databag, runlist);
        }
    }

    @Override
    public List<String> getRunListForGroup(String group) {
        return this.runListForGroup.apply(group);
    }

    @Override
    public byte[] decrypt(InputSupplier<? extends InputStream> supplier) throws IOException {
        return ByteStreams.toByteArray((InputSupplier)new RSADecryptingPayload(Payloads.newPayload((Object)supplier.getInput()), (Key)this.privateKey.get()));
    }

    @Override
    public byte[] encrypt(InputSupplier<? extends InputStream> supplier) throws IOException {
        return ByteStreams.toByteArray((InputSupplier)new RSAEncryptingPayload(Payloads.newPayload((Object)supplier.getInput()), (Key)this.privateKey.get()));
    }
}

