/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.json.Json;

@Singleton
public class RunListForGroup
implements Function<String, List<String>> {
    public static final Type RUN_LIST_TYPE = new TypeLiteral<Map<String, Object>>(){}.getType();
    private final ChefApi api;
    private final Json json;
    private final String databag;

    @Inject
    public RunListForGroup(@Named(value="chef.bootstrap-databag") String databag, ChefApi api, Json json) {
        this.databag = (String)Preconditions.checkNotNull((Object)databag, (Object)"databag");
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
    }

    public List<String> apply(String from) {
        DatabagItem list = this.api.getDatabagItem(this.databag, from);
        Preconditions.checkState((list != null ? 1 : 0) != 0, (String)"databag item %s/%s not found", (Object[])new Object[]{this.databag, from});
        return (List)((Map)this.json.fromJson(list.toString(), RUN_LIST_TYPE)).get("run_list");
    }
}

