/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.InputSuppliers;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.io.payloads.RSAEncryptingPayload;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.util.Strings2;

@Singleton
public class SignedHeaderAuth
implements HttpRequestFilter {
    public static final String SIGNING_DESCRIPTION = "version=1.0";
    private final SignatureWire signatureWire;
    private final String userId;
    private final PrivateKey privateKey;
    private final Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final String emptyStringHash;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SignedHeaderAuth(SignatureWire signatureWire, @Identity String userId, PrivateKey privateKey, @TimeStamp Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils) {
        this.signatureWire = signatureWire;
        this.userId = userId;
        this.privateKey = privateKey;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
        this.emptyStringHash = this.hashBody((Payload)Payloads.newStringPayload((String)""));
        this.utils = utils;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        String contentHash = this.hashBody(request.getPayload());
        ArrayListMultimap headers = ArrayListMultimap.create();
        headers.put((Object)"X-Ops-Content-Hash", (Object)contentHash);
        String timestamp = (String)this.timeStampProvider.get();
        String toSign = this.createStringToSign(request.getMethod(), this.hashPath(request.getEndpoint().getPath()), contentHash, timestamp);
        headers.put((Object)"X-Ops-Userid", (Object)this.userId);
        headers.put((Object)"X-Ops-Sign", (Object)SIGNING_DESCRIPTION);
        request = this.calculateAndReplaceAuthorizationHeaders(request, toSign);
        headers.put((Object)"X-Ops-Timestamp", (Object)timestamp);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return ((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)headers)).build();
    }

    @VisibleForTesting
    HttpRequest calculateAndReplaceAuthorizationHeaders(HttpRequest request, String toSign) throws HttpException {
        String signature = this.sign(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream((String)signature));
        }
        String[] signatureLines = (String[])Iterables.toArray((Iterable)Splitter.fixedLength((int)60).split((CharSequence)signature), String.class);
        ArrayListMultimap headers = ArrayListMultimap.create();
        for (int i = 0; i < signatureLines.length; ++i) {
            headers.put((Object)("X-Ops-Authorization-" + (i + 1)), (Object)signatureLines[i]);
        }
        return ((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)headers)).build();
    }

    public String createStringToSign(String request, String hashedPath, String contentHash, String timestamp) {
        return "Method:" + request + "\n" + "Hashed Path:" + hashedPath + "\n" + "X-Ops-Content-Hash:" + contentHash + "\n" + "X-Ops-Timestamp:" + timestamp + "\n" + "X-Ops-UserId:" + this.userId;
    }

    @VisibleForTesting
    String hashPath(String path) {
        try {
            return CryptoStreams.base64((byte[])CryptoStreams.digest((InputSupplier)InputSuppliers.of((String)this.canonicalPath(path)), (MessageDigest)this.crypto.sha1()));
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new HttpException("error creating sigature for path: " + path, (Throwable)e);
        }
    }

    @VisibleForTesting
    String canonicalPath(String path) {
        return (path = path.replaceAll("\\/+", "/")).endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
    }

    @VisibleForTesting
    String hashBody(Payload payload) {
        if (payload == null) {
            return this.emptyStringHash;
        }
        Preconditions.checkArgument(((payload = this.useTheFilePartIfForm(payload)) != null ? 1 : 0) != 0, (Object)"payload was null");
        Preconditions.checkArgument((boolean)payload.isRepeatable(), (Object)("payload must be repeatable: " + payload));
        try {
            return CryptoStreams.base64((byte[])CryptoStreams.digest((InputSupplier)payload, (MessageDigest)this.crypto.sha1()));
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new HttpException("error creating sigature for payload: " + payload, (Throwable)e);
        }
    }

    private Payload useTheFilePartIfForm(Payload payload) {
        if (payload instanceof MultipartForm) {
            Iterable parts = (Iterable)((MultipartForm)MultipartForm.class.cast(payload)).getRawContent();
            try {
                payload = (Payload)Iterables.find((Iterable)parts, (Predicate)new Predicate<Part>(){

                    public boolean apply(Part input) {
                        return "file".equals(input.getName());
                    }
                });
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return payload;
    }

    public String sign(String toSign) {
        try {
            byte[] encrypted = ByteStreams.toByteArray((InputSupplier)new RSAEncryptingPayload((Payload)Payloads.newStringPayload((String)toSign), (Key)this.privateKey));
            return CryptoStreams.base64((byte[])encrypted);
        }
        catch (Exception e) {
            throw new HttpException("error signing request", (Throwable)e);
        }
    }
}

