/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.chef.domain.ChecksumStatus;

public class UploadSandbox {
    private URI uri;
    private Map<List<Byte>, ChecksumStatus> checksums = Maps.newLinkedHashMap();
    @SerializedName(value="sandbox_id")
    private String sandboxId;

    public UploadSandbox(URI uri, Map<List<Byte>, ChecksumStatus> checksums, String sandboxId) {
        this.uri = uri;
        this.checksums.putAll(checksums);
        this.sandboxId = sandboxId;
    }

    public UploadSandbox() {
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<List<Byte>, ChecksumStatus> getChecksums() {
        return this.checksums;
    }

    public String getSandboxId() {
        return this.sandboxId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksums == null ? 0 : ((Object)this.checksums).hashCode());
        result = 31 * result + (this.sandboxId == null ? 0 : this.sandboxId.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UploadSandbox other = (UploadSandbox)obj;
        if (this.checksums == null ? other.checksums != null : !((Object)this.checksums).equals(other.checksums)) {
            return false;
        }
        if (this.sandboxId == null ? other.sandboxId != null : !this.sandboxId.equals(other.sandboxId)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return "UploadSite [checksums=" + this.checksums + ", id=" + this.sandboxId + ", uri=" + this.uri + "]";
    }
}

