/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.config;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefAsyncApi;
import org.jclouds.chef.config.BaseChefRestClientModule;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.functions.ClientForGroup;
import org.jclouds.chef.functions.RunListForGroup;
import org.jclouds.chef.statements.InstallChefGems;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.scriptbuilder.domain.Statement;

@ConfiguresRestClient
public class ChefRestClientModule
extends BaseChefRestClientModule<ChefApi, ChefAsyncApi> {
    public ChefRestClientModule() {
        super(TypeToken.of(ChefApi.class), TypeToken.of(ChefAsyncApi.class));
    }

    @Provides
    @Singleton
    Map<String, List<String>> runListForGroup(RunListForGroup runListForGroup) {
        return new MapMaker().makeComputingMap((Function)runListForGroup);
    }

    @Provides
    @Singleton
    Map<String, Client> tagToClient(ClientForGroup groupToClient) {
        return new MapMaker().makeComputingMap((Function)groupToClient);
    }

    protected void configure() {
        this.bind(Statement.class).annotatedWith((Annotation)Names.named((String)"installChefGems")).to(InstallChefGems.class);
        super.configure();
    }
}

