/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.InputSupplier;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.inject.AbstractModule;
import com.google.inject.ImplementedBy;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.config.CookbookParser;
import org.jclouds.chef.config.CookbookVersionsParser;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.functions.ParseCookbookDefinitionFromJson;
import org.jclouds.chef.functions.ParseCookbookVersionsV09FromJson;
import org.jclouds.chef.functions.ParseCookbookVersionsV10FromJson;
import org.jclouds.chef.functions.ParseKeySetFromJson;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.InputSuppliers;
import org.jclouds.json.config.GsonModule;
import org.jclouds.json.internal.NullHackJsonLiteralAdapter;
import org.jclouds.rest.annotations.ApiVersion;

public class ChefParserModule
extends AbstractModule {
    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings(DataBagItemAdapter adapter, PrivateKeyAdapter privateAdapter, PublicKeyAdapter publicAdapter, X509CertificateAdapter certAdapter) {
        return ImmutableMap.of(DatabagItem.class, (Object)((Object)adapter), PrivateKey.class, (Object)privateAdapter, PublicKey.class, (Object)publicAdapter, X509Certificate.class, (Object)certAdapter);
    }

    @Provides
    @Singleton
    @CookbookParser
    public Function<HttpResponse, Set<String>> provideCookbookDefinitionAdapter(@ApiVersion String apiVersion, ParseCookbookDefinitionFromJson v10parser, ParseKeySetFromJson v09parser) {
        Pattern versionPattern = Pattern.compile("\\d\\.(\\d)\\.\\d");
        Matcher m = versionPattern.matcher(apiVersion);
        if (m.matches()) {
            return Integer.valueOf(m.group(1)) > 9 ? v10parser : v09parser;
        }
        return v10parser;
    }

    @Provides
    @Singleton
    @CookbookVersionsParser
    public Function<HttpResponse, Set<String>> provideCookbookDefinitionAdapter(@ApiVersion String apiVersion, ParseCookbookVersionsV10FromJson v10parser, ParseCookbookVersionsV09FromJson v09parser) {
        Pattern versionPattern = Pattern.compile("\\d\\.(\\d)\\.\\d");
        Matcher m = versionPattern.matcher(apiVersion);
        if (m.matches()) {
            return Integer.valueOf(m.group(1)) > 9 ? v10parser : v09parser;
        }
        return v10parser;
    }

    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    private static class IdHolder {
        private String id;

        private IdHolder() {
        }
    }

    @Singleton
    public static class DataBagItemAdapter
    extends NullHackJsonLiteralAdapter<DatabagItem> {
        final Gson gson = new Gson();

        protected DatabagItem createJsonLiteralFromRawJson(String text) {
            IdHolder idHolder = (IdHolder)this.gson.fromJson(text, IdHolder.class);
            Preconditions.checkState((idHolder.id != null ? 1 : 0) != 0, (String)"databag item must be a json hash ex. {\"id\":\"item1\",\"my_key\":\"my_data\"}; was %s", (Object[])new Object[]{text});
            text = text.replaceFirst(String.format("\\{\"id\"[ ]?:\"%s\",", idHolder.id), "{");
            return new DatabagItem(idHolder.id, text);
        }

        protected String toString(DatabagItem value) {
            String text = value.toString();
            try {
                IdHolder idHolder = (IdHolder)this.gson.fromJson(text, IdHolder.class);
                if (idHolder.id == null) {
                    text = text.replaceFirst("\\{", String.format("{\"id\":\"%s\",", value.getId()));
                } else {
                    Preconditions.checkArgument((boolean)value.getId().equals(idHolder.id), (String)"incorrect id in databagItem text, should be %s: was %s", (Object[])new Object[]{value.getId(), idHolder.id});
                }
            }
            catch (JsonSyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            return text;
        }
    }

    @Singleton
    public static class X509CertificateAdapterImpl
    implements X509CertificateAdapter {
        private final Crypto crypto;

        @Inject
        X509CertificateAdapterImpl(Crypto crypto) {
            this.crypto = crypto;
        }

        public X509Certificate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String keyText = json.getAsString().replaceAll("\\n", "\n");
            try {
                return Pems.x509Certificate((InputSupplier)InputSuppliers.of((String)keyText), (CertificateFactory)this.crypto.certFactory());
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (CertificateException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    @ImplementedBy(value=X509CertificateAdapterImpl.class)
    public static interface X509CertificateAdapter
    extends JsonDeserializer<X509Certificate> {
    }

    @Singleton
    public static class PublicKeyAdapterImpl
    implements PublicKeyAdapter {
        private final Crypto crypto;

        @Inject
        PublicKeyAdapterImpl(Crypto crypto) {
            this.crypto = crypto;
        }

        public PublicKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String keyText = json.getAsString().replaceAll("\\n", "\n");
            try {
                return this.crypto.rsaKeyFactory().generatePublic(Pems.publicKeySpec((InputSupplier)InputSuppliers.of((String)keyText)));
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (InvalidKeySpecException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    @ImplementedBy(value=PublicKeyAdapterImpl.class)
    public static interface PublicKeyAdapter
    extends JsonDeserializer<PublicKey> {
    }

    @Singleton
    public static class PrivateKeyAdapterImpl
    implements PrivateKeyAdapter {
        private final Crypto crypto;

        @Inject
        PrivateKeyAdapterImpl(Crypto crypto) {
            this.crypto = crypto;
        }

        public PrivateKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String keyText = json.getAsString().replaceAll("\\n", "\n");
            try {
                return this.crypto.rsaKeyFactory().generatePrivate(Pems.privateKeySpec((InputSupplier)InputSuppliers.of((String)keyText)));
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (InvalidKeySpecException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    @ImplementedBy(value=PrivateKeyAdapterImpl.class)
    public static interface PrivateKeyAdapter
    extends JsonDeserializer<PrivateKey> {
    }
}

