/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.config;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.InputSupplier;
import com.google.common.reflect.TypeToken;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.config.Validator;
import org.jclouds.chef.handlers.ChefApiErrorRetryHandler;
import org.jclouds.chef.handlers.ChefErrorHandler;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.io.InputSuppliers;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
public class BaseChefRestClientModule<S, A>
extends RestClientModule<S, A> {
    protected BaseChefRestClientModule(TypeToken<S> syncApiType, TypeToken<A> asyncApiType) {
        super(syncApiType, asyncApiType);
    }

    protected BaseChefRestClientModule(TypeToken<S> syncApiType, TypeToken<A> asyncApiType, Map<Class<?>, Class<?>> delegates) {
        super(syncApiType, asyncApiType, delegates);
    }

    @Provides
    @TimeStamp
    protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
        return (String)cache.get();
    }

    @Provides
    @TimeStamp
    Supplier<String> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds, final DateService dateService) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<String>(){

            public String get() {
                return dateService.iso8601SecondsDateFormat();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    public PrivateKey provideKey(Crypto crypto, @Credential String pem) throws InvalidKeySpecException, IOException {
        return crypto.rsaKeyFactory().generatePrivate(Pems.privateKeySpec((InputSupplier)InputSuppliers.of((String)pem)));
    }

    @Provides
    @Singleton
    @Validator
    public Optional<String> provideValidatorName(Injector injector) {
        Key key = Key.get(String.class, (Annotation)Names.named((String)"chef.validator-name"));
        try {
            return Optional.of((Object)injector.getInstance(key));
        }
        catch (ConfigurationException ex) {
            return Optional.absent();
        }
    }

    @Provides
    @Singleton
    @Validator
    public Optional<PrivateKey> provideValidatorCredential(Crypto crypto, Injector injector) throws InvalidKeySpecException, IOException {
        Key key = Key.get(String.class, (Annotation)Names.named((String)"chef.validator-credential"));
        try {
            String validatorCredential = (String)injector.getInstance(key);
            PrivateKey validatorKey = crypto.rsaKeyFactory().generatePrivate(Pems.privateKeySpec((InputSupplier)InputSuppliers.of((String)validatorCredential)));
            return Optional.of((Object)validatorKey);
        }
        catch (ConfigurationException ex) {
            return Optional.absent();
        }
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ChefErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ChefErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ChefErrorHandler.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(ChefApiErrorRetryHandler.class);
    }
}

