/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.chef.binders.BindChecksumsToJsonPayload;
import org.jclouds.chef.binders.BindCreateClientOptionsToJsonPayload;
import org.jclouds.chef.binders.BindGenerateKeyForClientToJsonPayload;
import org.jclouds.chef.binders.BindIsCompletedToJsonPayload;
import org.jclouds.chef.binders.BindNameToJsonPayload;
import org.jclouds.chef.binders.DatabagItemId;
import org.jclouds.chef.binders.NodeName;
import org.jclouds.chef.binders.RoleName;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.domain.Resource;
import org.jclouds.chef.domain.Role;
import org.jclouds.chef.domain.Sandbox;
import org.jclouds.chef.domain.SearchResult;
import org.jclouds.chef.domain.UploadSandbox;
import org.jclouds.chef.filters.SignedHeaderAuth;
import org.jclouds.chef.functions.ParseCookbookDefinitionCheckingChefVersion;
import org.jclouds.chef.functions.ParseCookbookVersionsCheckingChefVersion;
import org.jclouds.chef.functions.ParseKeySetFromJson;
import org.jclouds.chef.functions.ParseSearchClientsFromJson;
import org.jclouds.chef.functions.ParseSearchDatabagFromJson;
import org.jclouds.chef.functions.ParseSearchNodesFromJson;
import org.jclouds.chef.functions.ParseSearchRolesFromJson;
import org.jclouds.chef.functions.UriForResource;
import org.jclouds.chef.options.CreateClientOptions;
import org.jclouds.chef.options.SearchOptions;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={SignedHeaderAuth.class})
@Headers(keys={"X-Chef-Version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/json"})
public interface ChefAsyncApi {
    public static final String VERSION = "0.10.8";

    @POST
    @Path(value="/sandboxes")
    public ListenableFuture<UploadSandbox> getUploadSandboxForChecksums(@BinderParam(value=BindChecksumsToJsonPayload.class) Set<List<Byte>> var1);

    @PUT
    @Produces(value={"application/x-binary"})
    public ListenableFuture<Void> uploadContent(@EndpointParam URI var1, Payload var2);

    @PUT
    @Path(value="/sandboxes/{id}")
    public ListenableFuture<Sandbox> commitSandbox(@PathParam(value="id") String var1, @BinderParam(value=BindIsCompletedToJsonPayload.class) boolean var2);

    @GET
    @Path(value="/cookbooks")
    @ResponseParser(value=ParseCookbookDefinitionCheckingChefVersion.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listCookbooks();

    @PUT
    @Path(value="/cookbooks/{cookbookname}/{version}")
    public ListenableFuture<CookbookVersion> updateCookbook(@PathParam(value="cookbookname") String var1, @PathParam(value="version") String var2, @BinderParam(value=BindToJsonPayload.class) CookbookVersion var3);

    @DELETE
    @Path(value="/cookbooks/{cookbookname}/{version}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<CookbookVersion> deleteCookbook(@PathParam(value="cookbookname") String var1, @PathParam(value="version") String var2);

    @GET
    @Path(value="/cookbooks/{cookbookname}")
    @ResponseParser(value=ParseCookbookVersionsCheckingChefVersion.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> getVersionsOfCookbook(@PathParam(value="cookbookname") String var1);

    @GET
    @Path(value="/cookbooks/{cookbookname}/{version}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<CookbookVersion> getCookbook(@PathParam(value="cookbookname") String var1, @PathParam(value="version") String var2);

    @POST
    @Path(value="/clients")
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<Client> createClient(@PayloadParam(value="name") String var1);

    @POST
    @Path(value="/clients")
    @MapBinder(value=BindCreateClientOptionsToJsonPayload.class)
    public ListenableFuture<Client> createClient(@PayloadParam(value="name") String var1, CreateClientOptions var2);

    @PUT
    @Path(value="/clients/{clientname}")
    public ListenableFuture<Client> generateKeyForClient(@PathParam(value="clientname") @BinderParam(value=BindGenerateKeyForClientToJsonPayload.class) String var1);

    @HEAD
    @Path(value="/clients/{clientname}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> clientExists(@PathParam(value="clientname") String var1);

    @GET
    @Path(value="/clients/{clientname}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Client> getClient(@PathParam(value="clientname") String var1);

    @DELETE
    @Path(value="/clients/{clientname}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Client> deleteClient(@PathParam(value="clientname") String var1);

    @GET
    @Path(value="/clients")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listClients();

    @POST
    @Path(value="/nodes")
    public ListenableFuture<Void> createNode(@BinderParam(value=BindToJsonPayload.class) Node var1);

    @PUT
    @Path(value="/nodes/{nodename}")
    public ListenableFuture<Node> updateNode(@PathParam(value="nodename") @ParamParser(value=NodeName.class) @BinderParam(value=BindToJsonPayload.class) Node var1);

    @HEAD
    @Path(value="/nodes/{nodename}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> nodeExists(@PathParam(value="nodename") String var1);

    @GET
    @Path(value="/nodes/{nodename}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Node> getNode(@PathParam(value="nodename") String var1);

    @DELETE
    @Path(value="/nodes/{nodename}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Node> deleteNode(@PathParam(value="nodename") String var1);

    @GET
    @Path(value="/nodes")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listNodes();

    @POST
    @Path(value="/roles")
    public ListenableFuture<Void> createRole(@BinderParam(value=BindToJsonPayload.class) Role var1);

    @PUT
    @Path(value="/roles/{rolename}")
    public ListenableFuture<Role> updateRole(@PathParam(value="rolename") @ParamParser(value=RoleName.class) @BinderParam(value=BindToJsonPayload.class) Role var1);

    @HEAD
    @Path(value="/roles/{rolename}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> roleExists(@PathParam(value="rolename") String var1);

    @GET
    @Path(value="/roles/{rolename}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Role> getRole(@PathParam(value="rolename") String var1);

    @DELETE
    @Path(value="/roles/{rolename}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Role> deleteRole(@PathParam(value="rolename") String var1);

    @GET
    @Path(value="/roles")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listRoles();

    @GET
    @Path(value="/data")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listDatabags();

    @POST
    @Path(value="/data")
    public ListenableFuture<Void> createDatabag(@BinderParam(value=BindNameToJsonPayload.class) String var1);

    @HEAD
    @Path(value="/data/{name}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> databagExists(@PathParam(value="name") String var1);

    @DELETE
    @Path(value="/data/{name}")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteDatabag(@PathParam(value="name") String var1);

    @GET
    @Path(value="/data/{name}")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listDatabagItems(@PathParam(value="name") String var1);

    @POST
    @Path(value="/data/{databagName}")
    public ListenableFuture<DatabagItem> createDatabagItem(@PathParam(value="databagName") String var1, @BinderParam(value=BindToJsonPayload.class) DatabagItem var2);

    @PUT
    @Path(value="/data/{databagName}/{databagItemId}")
    public ListenableFuture<DatabagItem> updateDatabagItem(@PathParam(value="databagName") String var1, @PathParam(value="databagItemId") @ParamParser(value=DatabagItemId.class) @BinderParam(value=BindToJsonPayload.class) DatabagItem var2);

    @HEAD
    @Path(value="/data/{databagName}/{databagItemId}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> databagItemExists(@PathParam(value="databagName") String var1, @PathParam(value="databagItemId") String var2);

    @GET
    @Path(value="/data/{databagName}/{databagItemId}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<DatabagItem> getDatabagItem(@PathParam(value="databagName") String var1, @PathParam(value="databagItemId") String var2);

    @DELETE
    @Path(value="/data/{databagName}/{databagItemId}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<DatabagItem> deleteDatabagItem(@PathParam(value="databagName") String var1, @PathParam(value="databagItemId") String var2);

    @GET
    @Path(value="/search")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listSearchIndexes();

    @GET
    @Path(value="/search/role")
    @ResponseParser(value=ParseSearchRolesFromJson.class)
    public ListenableFuture<? extends SearchResult<? extends Role>> searchRoles();

    @GET
    @Path(value="/search/role")
    @ResponseParser(value=ParseSearchRolesFromJson.class)
    public ListenableFuture<? extends SearchResult<? extends Role>> searchRoles(SearchOptions var1);

    @GET
    @Path(value="/search/client")
    @ResponseParser(value=ParseSearchClientsFromJson.class)
    public ListenableFuture<? extends SearchResult<? extends Client>> searchClients();

    @GET
    @Path(value="/search/client")
    @ResponseParser(value=ParseSearchClientsFromJson.class)
    public ListenableFuture<? extends SearchResult<? extends Client>> searchClients(SearchOptions var1);

    @GET
    @Path(value="/search/node")
    @ResponseParser(value=ParseSearchNodesFromJson.class)
    public ListenableFuture<? extends SearchResult<? extends Node>> searchNodes();

    @GET
    @Path(value="/search/node")
    @ResponseParser(value=ParseSearchNodesFromJson.class)
    public ListenableFuture<? extends SearchResult<? extends Node>> searchNodes(SearchOptions var1);

    @GET
    @Path(value="/search/{databagName}")
    @ResponseParser(value=ParseSearchDatabagFromJson.class)
    public ListenableFuture<? extends SearchResult<? extends DatabagItem>> searchDatabag(@PathParam(value="databagName") String var1);

    @GET
    @Path(value="/search/{databagName}")
    @ResponseParser(value=ParseSearchDatabagFromJson.class)
    public ListenableFuture<? extends SearchResult<? extends DatabagItem>> searchDatabag(@PathParam(value="databagName") String var1, SearchOptions var2);

    @GET
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<InputStream> getResourceContents(@EndpointParam(parser=UriForResource.class) Resource var1);
}

