/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefAsyncApi;
import org.jclouds.chef.ChefContext;
import org.jclouds.chef.config.ChefParserModule;
import org.jclouds.chef.config.ChefRestClientModule;
import org.jclouds.ohai.config.JMXOhaiModule;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class ChefApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 3450830053589179249L;

    public Builder toBuilder() {
        return new Builder(this.getApi(), this.getAsyncApi()).fromApiMetadata((ApiMetadata)this);
    }

    public ChefApiMetadata() {
        this(new Builder(ChefApi.class, ChefAsyncApi.class));
    }

    protected ChefApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)Builder.class.cast((Object)builder));
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.session-interval", "1");
        properties.setProperty("chef.bootstrap-databag", "bootstrap");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder(Class<?> api, Class<?> asyncApi) {
            super(api, asyncApi);
            this.id("chef").name("OpsCode Chef Api").identityName("User").credentialName("Certificate").version("0.10.8").documentation(URI.create("http://wiki.opscode.com/display/chef/Server+API")).defaultEndpoint("http://localhost:4000").defaultProperties(ChefApiMetadata.defaultProperties()).context(TypeToken.of(ChefContext.class)).defaultModules((Set)ImmutableSet.of(ChefRestClientModule.class, ChefParserModule.class, JMXOhaiModule.class));
        }

        public ChefApiMetadata build() {
            return new ChefApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

