/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.domain.Resource;
import org.jclouds.chef.domain.Role;
import org.jclouds.chef.domain.Sandbox;
import org.jclouds.chef.domain.SearchResult;
import org.jclouds.chef.domain.UploadSandbox;
import org.jclouds.chef.options.CreateClientOptions;
import org.jclouds.chef.options.SearchOptions;
import org.jclouds.concurrent.Timeout;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.binders.BindToJsonPayload;

@Timeout(duration=30L, timeUnit=TimeUnit.SECONDS)
public interface ChefApi {
    public UploadSandbox getUploadSandboxForChecksums(Set<List<Byte>> var1);

    public void uploadContent(URI var1, Payload var2);

    public Sandbox commitSandbox(String var1, boolean var2);

    public Set<String> listCookbooks();

    @Timeout(duration=10L, timeUnit=TimeUnit.MINUTES)
    public CookbookVersion updateCookbook(String var1, String var2, CookbookVersion var3);

    public CookbookVersion deleteCookbook(String var1, String var2);

    public Set<String> getVersionsOfCookbook(String var1);

    public CookbookVersion getCookbook(String var1, String var2);

    @Timeout(duration=120L, timeUnit=TimeUnit.SECONDS)
    public Client createClient(String var1);

    @Timeout(duration=120L, timeUnit=TimeUnit.SECONDS)
    public Client createClient(String var1, CreateClientOptions var2);

    @Timeout(duration=120L, timeUnit=TimeUnit.SECONDS)
    public Client generateKeyForClient(String var1);

    public Set<String> listClients();

    public boolean clientExists(String var1);

    public Client deleteClient(String var1);

    public Client getClient(String var1);

    @Timeout(duration=120L, timeUnit=TimeUnit.SECONDS)
    public void createNode(Node var1);

    @Timeout(duration=10L, timeUnit=TimeUnit.MINUTES)
    public Node updateNode(Node var1);

    public Set<String> listNodes();

    public boolean nodeExists(String var1);

    public Node deleteNode(String var1);

    public Node getNode(String var1);

    @Timeout(duration=120L, timeUnit=TimeUnit.SECONDS)
    public void createRole(Role var1);

    @Timeout(duration=10L, timeUnit=TimeUnit.MINUTES)
    public Role updateRole(Role var1);

    public Set<String> listRoles();

    public boolean roleExists(String var1);

    public Role deleteRole(String var1);

    public Role getRole(String var1);

    public Set<String> listDatabags();

    public void createDatabag(String var1);

    public boolean databagExists(String var1);

    public void deleteDatabag(String var1);

    public Set<String> listDatabagItems(String var1);

    public DatabagItem createDatabagItem(String var1, @BinderParam(value=BindToJsonPayload.class) DatabagItem var2);

    public DatabagItem updateDatabagItem(String var1, DatabagItem var2);

    public boolean databagItemExists(String var1, String var2);

    public DatabagItem getDatabagItem(String var1, String var2);

    public DatabagItem deleteDatabagItem(String var1, String var2);

    public Set<String> listSearchIndexes();

    public SearchResult<? extends Role> searchRoles();

    public SearchResult<? extends Role> searchRoles(SearchOptions var1);

    public SearchResult<? extends Client> searchClients();

    public SearchResult<? extends Client> searchClients(SearchOptions var1);

    public SearchResult<? extends Node> searchNodes();

    public SearchResult<? extends Node> searchNodes(SearchOptions var1);

    public SearchResult<? extends DatabagItem> searchDatabag(String var1);

    public SearchResult<? extends DatabagItem> searchDatabag(String var1, SearchOptions var2);

    public InputStream getResourceContents(Resource var1);
}

