/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterceptionTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptionTypeRegistry.class);
    private static final Map<InterceptionType, Class<? extends Annotation>> INTERCEPTOR_ANNOTATION_CLASSES;

    public static Collection<InterceptionType> getSupportedInterceptionTypes() {
        return INTERCEPTOR_ANNOTATION_CLASSES.keySet();
    }

    public static boolean isSupported(InterceptionType interceptionType) {
        return INTERCEPTOR_ANNOTATION_CLASSES.containsKey((Object)interceptionType);
    }

    public static Class<? extends Annotation> getAnnotationClass(InterceptionType interceptionType) {
        return INTERCEPTOR_ANNOTATION_CLASSES.get((Object)interceptionType);
    }

    static {
        HashMap interceptionAnnotationClasses = new HashMap();
        for (InterceptionType interceptionType : InterceptionType.values()) {
            try {
                interceptionAnnotationClasses.put(interceptionType, ReflectionUtils.classForName(interceptionType.annotationClassName()));
            }
            catch (Exception e) {
                LOG.warn("Class '" + interceptionType.annotationClassName() + "' not found, interception based on it is not enabled");
            }
        }
        INTERCEPTOR_ANNOTATION_CLASSES = Collections.unmodifiableMap(interceptionAnnotationClasses);
    }
}

