/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Stereotype;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.discovery.AbstractDiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.FileSystemBeanArchiveHandler;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.reflection.Reflections;

public class ReflectionDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private final List<Class<? extends Annotation>> metaAnnotations;
    private final TypeDiscoveryConfiguration typeDiscoveryConfiguration;

    public ReflectionDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap, TypeDiscoveryConfiguration typeDiscoveryConfiguration) {
        super(resourceLoader, bootstrap);
        this.typeDiscoveryConfiguration = typeDiscoveryConfiguration;
        this.metaAnnotations = ImmutableList.of(Stereotype.class, NormalScope.class);
        this.registerHandler(new FileSystemBeanArchiveHandler());
    }

    @Override
    protected WeldBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        CommonLogger.LOG.reflectionFallback();
        Iterator<String> classIterator = builder.getClassIterator();
        while (classIterator.hasNext()) {
            String className = classIterator.next();
            Class clazz = Reflections.loadClass(className, this.resourceLoader);
            if (this.hasBeanDefiningAnnotation(clazz, this.typeDiscoveryConfiguration)) continue;
            classIterator.remove();
        }
        return builder.build();
    }

    private boolean hasBeanDefiningAnnotation(Class<?> clazz, TypeDiscoveryConfiguration typeDiscoveryConfiguration) {
        for (Class<? extends Annotation> beanDefiningAnnotation : typeDiscoveryConfiguration.getKnownBeanDefiningAnnotations()) {
            if (!clazz.isAnnotationPresent(beanDefiningAnnotation)) continue;
            return true;
        }
        for (Class<? extends Annotation> metaAnnotation : this.metaAnnotations) {
            if (!org.jboss.weld.environment.util.Reflections.hasBeanDefiningMetaAnnotationSpecified(clazz.getAnnotations(), metaAnnotation)) continue;
            return true;
        }
        return false;
    }
}

