/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DefaultBeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;

public abstract class AbstractDiscoveryStrategy
implements DiscoveryStrategy {
    private static final Logger log = Logger.getLogger(AbstractDiscoveryStrategy.class);
    protected final ResourceLoader resourceLoader;
    protected final Bootstrap bootstrap;
    protected BeanArchiveScanner scanner;
    private final List<BeanArchiveHandler> handlers;

    public AbstractDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap) {
        this.resourceLoader = resourceLoader;
        this.bootstrap = bootstrap;
        this.handlers = new LinkedList<BeanArchiveHandler>();
    }

    @Override
    public void setScanner(BeanArchiveScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public Set<WeldBeanDeploymentArchive> performDiscovery() {
        if (this.scanner == null) {
            this.scanner = new DefaultBeanArchiveScanner(this.resourceLoader, this.bootstrap);
        }
        ArrayList<BeanArchiveBuilder> beanArchiveBuilders = new ArrayList<BeanArchiveBuilder>();
        for (Map.Entry<BeansXml, String> entry : this.scanner.scan().entrySet()) {
            String ref = entry.getValue();
            BeanArchiveBuilder builder = null;
            for (BeanArchiveHandler handler : this.handlers) {
                builder = handler.handle(ref);
                if (builder == null) continue;
                builder.setId(ref);
                builder.setBeansXml(entry.getKey());
                beanArchiveBuilders.add(builder);
                break;
            }
            if (builder != null) continue;
            log.warnv("The bean archive reference {0} cannot be handled by any BeanArchiveHandler: {1}", (Object)ref, (Object)this.handlers);
        }
        this.beforeDiscovery(beanArchiveBuilders);
        HashSet<WeldBeanDeploymentArchive> archives = new HashSet<WeldBeanDeploymentArchive>();
        block7: for (BeanArchiveBuilder builder : beanArchiveBuilders) {
            BeansXml beansXml = builder.getBeansXml();
            switch (beansXml.getBeanDiscoveryMode()) {
                case ALL: {
                    this.addToArchives(archives, this.processAllDiscovery(builder));
                    continue block7;
                }
                case ANNOTATED: {
                    this.addToArchives(archives, this.processAnnotatedDiscovery(builder));
                    continue block7;
                }
                case NONE: {
                    this.addToArchives(archives, this.processNoneDiscovery(builder));
                    continue block7;
                }
            }
            CommonLogger.LOG.undefinedBeanDiscoveryValue((Object)beansXml.getBeanDiscoveryMode());
        }
        this.afterDiscovery(archives);
        return archives;
    }

    @Override
    public ClassFileServices getClassFileServices() {
        return null;
    }

    protected void assignVisibility(Set<WeldBeanDeploymentArchive> deploymentArchives) {
        for (WeldBeanDeploymentArchive archive : deploymentArchives) {
            archive.setAccessibleBeanDeploymentArchives(deploymentArchives);
        }
    }

    protected void addToArchives(Set<WeldBeanDeploymentArchive> deploymentArchives, WeldBeanDeploymentArchive bda) {
        if (bda != null) {
            deploymentArchives.add(bda);
        }
    }

    protected void beforeDiscovery(Collection<BeanArchiveBuilder> builders) {
    }

    protected void afterDiscovery(Set<WeldBeanDeploymentArchive> archives) {
        this.assignVisibility(archives);
    }

    protected WeldBeanDeploymentArchive processNoneDiscovery(BeanArchiveBuilder builder) {
        return null;
    }

    protected WeldBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        throw new UnsupportedOperationException();
    }

    protected WeldBeanDeploymentArchive processAllDiscovery(BeanArchiveBuilder builder) {
        return builder.build();
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public void registerHandler(BeanArchiveHandler handler) {
        this.handlers.add(handler);
    }
}

