/*
 ** Authored by Timothy Gerard Endres
 ** <mailto:time@gjt.org>  <http://www.trustice.com>
 **
 ** This work has been placed into the public domain.
 ** You may use this work in any way and for any purpose you wish.
 **
 ** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
 ** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
 ** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
 ** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
 ** REDISTRIBUTION OF THIS SOFTWARE.
 **
 */

package org.jboss.shrinkwrap.impl.base.io.tar;

/**
 * This interface is provided to TarArchive to display progress information during operation. This is required to
 * display the results of the 'list' operation.
 */

public interface TarProgressDisplay {
    /**
     * Display a progress message.
     *
     * @param msg
     *            The message to display.
     */

    void showTarProgressMessage(String msg);
}
