/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.util;

import java.io.File;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validate {
    private Validate() {
    }

    public static void notNull(Object obj, String message) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection<?> collection, String message) throws IllegalArgumentException {
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrEmpty(String string, String message) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isReadable(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, message);
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isWriteableDirectory(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, message);
        File file = new File(path);
        if (!(file.exists() && file.isDirectory() && file.canWrite() && file.canExecute())) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullAndNoNullValues(Object[] objects, String message) {
        Validate.notNull(objects, message);
        for (Object object : objects) {
            Validate.notNull(object, message);
        }
    }
}

