/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtil {
    private static final Logger log = Logger.getLogger(IOUtil.class.getName());
    private static final String CHARSET_UTF8 = "UTF-8";

    private IOUtil() {
        throw new UnsupportedOperationException("No instances should be created; stateless class");
    }

    public static String asUTF8String(InputStream in) {
        Validate.notNull(in, "Stream must be specified");
        StringBuilder buffer = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, CHARSET_UTF8));
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append(13);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in obtaining string from " + in, ioe);
        }
        finally {
            block11: {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    if (!log.isLoggable(Level.FINER)) break block11;
                    log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                }
            }
        }
        return buffer.toString();
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int read = 0;
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
        output.flush();
    }

    public static void bufferedWriteWithFlush(OutputStream output, byte[] content) throws IOException {
        int size = 4096;
        int offset = 0;
        while (content.length - (offset + 4096) > 4096) {
            output.write(content, offset, offset + 4096);
            offset += 4096;
        }
        output.write(content, offset, content.length);
        output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyWithClose(InputStream input, OutputStream output) throws IOException {
        try {
            IOUtil.copy(input, output);
        }
        finally {
            block13: {
                block12: {
                    try {
                        input.close();
                    }
                    catch (IOException ignore) {
                        if (!log.isLoggable(Level.FINER)) break block12;
                        log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                    }
                }
                try {
                    output.close();
                }
                catch (IOException ignore) {
                    if (!log.isLoggable(Level.FINER)) break block13;
                    log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                }
            }
        }
    }

    private static void safelyClose(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException ignore) {
                    if (!log.isLoggable(Level.FINER)) break block3;
                    log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packageDirectories(File outputFile, File ... directories) throws IOException {
        Validate.notNullAndNoNullValues(directories, "Directories to be packaged must be specified");
        ZipOutputStream zipFile = new ZipOutputStream(new FileOutputStream(outputFile));
        for (File directory : directories) {
            for (String entry : IOUtil.fileListing(directory)) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(new File(directory, entry));
                    zipFile.putNextEntry(new ZipEntry(entry));
                    IOUtil.copy(fis, zipFile);
                }
                catch (Throwable throwable) {
                    IOUtil.safelyClose(fis);
                    throw throwable;
                }
                IOUtil.safelyClose(fis);
            }
        }
        IOUtil.safelyClose(zipFile);
    }

    public static List<String> fileListing(File directory) {
        ArrayList<String> list = new ArrayList<String>();
        IOUtil.generateFileList(list, directory, directory);
        return list;
    }

    private static void generateFileList(List<String> list, File root, File file) {
        if (file.isFile()) {
            list.add(file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1));
        } else if (file.isDirectory()) {
            for (File next : file.listFiles()) {
                IOUtil.generateFileList(list, root, next);
            }
        }
    }
}

