/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenEnvironment;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenModelResolver;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenRepositorySystem;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenSettingsBuilder;
import org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MavenEnvironmentImpl
implements MavenEnvironment {
    private static final Logger log = Logger.getLogger(MavenEnvironmentImpl.class.getName());
    private static final RemoteRepository MAVEN_CENTRAL = new RemoteRepository("central", "default", "http://repo1.maven.org/maven2");
    private MavenRepositorySystem system = new MavenRepositorySystem();
    private Settings settings = new MavenSettingsBuilder().buildDefaultSettings();
    private RepositorySystemSession session;
    private Stack<MavenDependency> dependencies = new Stack();
    private Set<MavenDependency> versionManagement = new LinkedHashSet<MavenDependency>();
    private Model model;
    private List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private boolean useMavenCentralRepository = true;

    public MavenEnvironmentImpl() {
        this.session = this.system.getSession(this.settings);
    }

    @Override
    public Set<MavenDependency> getVersionManagement() {
        return this.versionManagement;
    }

    @Override
    public Stack<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public MavenEnvironment regenerateSession() {
        this.session = this.system.getSession(this.settings);
        return this;
    }

    @Override
    public MavenEnvironment execute(ModelBuildingRequest request) {
        Model model;
        ModelBuildingResult result;
        request.setModelResolver((ModelResolver)new MavenModelResolver(this.system, this.session, this.getRemoteRepositories()));
        DefaultModelBuilder builder = new DefaultModelBuilderFactory().newInstance();
        try {
            result = builder.build(request);
        }
        catch (ModelBuildingException e) {
            String pomPath = request.getPomFile().getAbsolutePath();
            StringBuilder sb = new StringBuilder("Found ").append(e.getProblems().size()).append(" problems while building POM model from ").append(pomPath).append("\n");
            int counter = 1;
            for (ModelProblem problem : e.getProblems()) {
                sb.append(counter++).append("/ ").append(problem).append("\n");
            }
            throw new ResolutionException(sb.toString(), (Throwable)e);
        }
        this.model = model = result.getEffectiveModel();
        for (org.apache.maven.model.Repository repository : model.getRepositories()) {
            this.remoteRepositories.add(MavenConverter.asRemoteRepository(repository));
        }
        return this;
    }

    @Override
    public MavenEnvironment execute(SettingsBuildingRequest request) {
        MavenSettingsBuilder builder = new MavenSettingsBuilder();
        this.settings = builder.buildSettings(request);
        return this.goOffline(this.settings.isOffline());
    }

    @Override
    public Collection<ArtifactResult> execute(CollectRequest request, MavenResolutionFilter filter) throws DependencyResolutionException {
        return this.system.resolveDependencies(this.session, request, filter);
    }

    @Override
    public ArtifactResult execute(ArtifactRequest request) throws ArtifactResolutionException {
        return this.system.resolveArtifact(this.session, request);
    }

    @Override
    public MavenEnvironment disableReactor() {
        ((MavenRepositorySystemSession)this.session).setWorkspaceReader(null);
        return this;
    }

    @Override
    public List<RemoteRepository> getRemoteRepositories() {
        if (this.settings.isOffline()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No remote repositories available, working in offline mode");
            }
            return Collections.emptyList();
        }
        List actives = this.settings.getActiveProfiles();
        LinkedHashSet<RemoteRepository> enhancedRepos = new LinkedHashSet<RemoteRepository>();
        for (Map.Entry profile : this.settings.getProfilesAsMap().entrySet()) {
            Activation activation = ((Profile)profile.getValue()).getActivation();
            if (!actives.contains(profile.getKey()) && (activation == null || !activation.isActiveByDefault())) continue;
            for (Repository repo : ((Profile)profile.getValue()).getRepositories()) {
                enhancedRepos.add(MavenConverter.asRemoteRepository(repo));
            }
        }
        enhancedRepos.addAll(this.remoteRepositories);
        if (this.useMavenCentralRepository) {
            enhancedRepos.add(MAVEN_CENTRAL);
        }
        DefaultMirrorSelector dms = new DefaultMirrorSelector();
        for (Mirror mirror : this.settings.getMirrors()) {
            dms.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        LinkedHashSet<RemoteRepository> mirroredRepos = new LinkedHashSet<RemoteRepository>();
        for (RemoteRepository repository : enhancedRepos) {
            RemoteRepository mirror = dms.getMirror(repository);
            if (mirror != null) {
                mirroredRepos.add(mirror);
                continue;
            }
            mirroredRepos.add(repository);
        }
        for (RemoteRepository remoteRepository : mirroredRepos) {
            Server server = this.settings.getServer(remoteRepository.getId());
            if (server == null) continue;
            Authentication authentication = new Authentication(server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase());
            remoteRepository.setAuthentication(authentication);
        }
        if (log.isLoggable(Level.FINER)) {
            for (RemoteRepository repository : mirroredRepos) {
                log.finer("Repository " + repository.getUrl() + " have been made available for artifact resolution");
            }
        }
        return new ArrayList<RemoteRepository>(mirroredRepos);
    }

    @Override
    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.session.getArtifactTypeRegistry();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public MavenEnvironment goOffline(boolean value) {
        String goOffline = SecurityActions.getProperty("org.apache.maven.offline");
        if (goOffline != null) {
            this.settings.setOffline(Boolean.valueOf(goOffline).booleanValue());
            if (log.isLoggable(Level.FINER)) {
                log.finer("Offline settings is set via a system property. The new offline flag value is: " + this.settings.isOffline());
            }
        } else {
            this.settings.setOffline(value);
        }
        return this;
    }

    @Override
    public MavenEnvironment useCentralRepository(boolean useCentralRepository) {
        this.useMavenCentralRepository = useCentralRepository;
        return this;
    }
}

