/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.util;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.seam.mail.core.BaseMailMessage;
import org.jboss.seam.mail.core.EmailContact;
import org.jboss.seam.mail.core.EmailMessage;
import org.jboss.seam.mail.core.InvalidAddressException;
import org.jboss.seam.mail.core.MailConfig;
import org.jboss.seam.mail.core.MailException;
import org.jboss.seam.mail.core.MailSessionAuthenticator;
import org.jboss.seam.mail.core.SendFailedException;
import org.jboss.seam.mail.core.enumerations.EmailMessageType;
import org.jboss.seam.mail.core.enumerations.RecipientType;
import org.jboss.seam.mail.util.Strings;

public class MailUtility {
    public static InternetAddress internetAddress(String address) throws InvalidAddressException {
        try {
            return new InternetAddress(address);
        }
        catch (AddressException e) {
            throw new InvalidAddressException("Must be in format of a@b.com or Name<a@b.com> but was: \"" + address + "\"", (Throwable)e);
        }
    }

    public static Collection<InternetAddress> internetAddress(String ... addresses) throws InvalidAddressException {
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>();
        for (String address : addresses) {
            result.add(MailUtility.internetAddress(address));
        }
        return result;
    }

    public static InternetAddress internetAddress(String address, String name) throws InvalidAddressException {
        try {
            InternetAddress internetAddress = new InternetAddress(address);
            internetAddress.setPersonal(name);
            return internetAddress;
        }
        catch (AddressException e) {
            throw new InvalidAddressException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidAddressException((Throwable)e);
        }
    }

    public static InternetAddress internetAddress(EmailContact emailContact) throws InvalidAddressException {
        if (Strings.isNullOrBlank(emailContact.getName())) {
            return MailUtility.internetAddress(emailContact.getAddress());
        }
        return MailUtility.internetAddress(emailContact.getAddress(), emailContact.getName());
    }

    public static Collection<InternetAddress> internetAddress(Collection<? extends EmailContact> emailContacts) throws InvalidAddressException {
        HashSet<InternetAddress> internetAddresses = new HashSet<InternetAddress>();
        for (EmailContact emailContact : emailContacts) {
            internetAddresses.add(MailUtility.internetAddress(emailContact));
        }
        return internetAddresses;
    }

    public static InternetAddress[] getInternetAddressses(InternetAddress emailAddress) {
        InternetAddress[] internetAddresses = new InternetAddress[]{emailAddress};
        return internetAddresses;
    }

    public static InternetAddress[] getInternetAddressses(Collection<InternetAddress> recipients) {
        InternetAddress[] result = new InternetAddress[recipients.size()];
        recipients.toArray(result);
        return result;
    }

    public static String getHostName() {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            return localMachine.getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static List<InternetAddress> getInternetAddressses(Address[] addresses) throws InvalidAddressException {
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>();
        if (addresses != null) {
            for (Address a : addresses) {
                if (a.getType().equals("rfc822")) {
                    try {
                        result.add(new InternetAddress(a.toString()));
                        continue;
                    }
                    catch (AddressException e) {
                        throw new InvalidAddressException((Throwable)e);
                    }
                }
                throw new InvalidAddressException("Not type RFC822");
            }
        }
        return result;
    }

    public static List<org.jboss.seam.mail.core.Header> getHeaders(Enumeration<?> allHeaders) {
        LinkedList<org.jboss.seam.mail.core.Header> result = new LinkedList<org.jboss.seam.mail.core.Header>();
        while (allHeaders.hasMoreElements()) {
            Header h = (Header)allHeaders.nextElement();
            result.add(new org.jboss.seam.mail.core.Header(h.getName(), h.getValue()));
        }
        return result;
    }

    public static Session createSession(MailConfig mailConfig) {
        Session session;
        if (!Strings.isNullOrBlank(mailConfig.getJndiSessionName())) {
            try {
                return (Session)InitialContext.doLookup(mailConfig.getJndiSessionName());
            }
            catch (NamingException e) {
                throw new MailException("Unable to lookup JNDI JavaMail Session", (Throwable)e);
            }
        }
        Properties props = new Properties();
        if (!mailConfig.isValid()) {
            throw new MailException("Server Host and Server  Port must be set in MailConfig");
        }
        props.setProperty("mail.smtp.host", mailConfig.getServerHost());
        props.setProperty("mail.smtp.port", mailConfig.getServerPort().toString());
        props.setProperty("mail.smtp.starttls.enable", mailConfig.getEnableTls().toString());
        props.setProperty("mail.smtp.starttls.required", mailConfig.getRequireTls().toString());
        props.setProperty("mail.smtp.ssl.enable", mailConfig.getEnableSsl().toString());
        props.setProperty("mail.smtp.auth", mailConfig.getAuth().toString());
        if (!Strings.isNullOrBlank(mailConfig.getDomainName())) {
            props.put("mail.seam.domainName", mailConfig.getDomainName());
        }
        if (mailConfig.getUsername() != null && mailConfig.getUsername().length() != 0 && mailConfig.getPassword() != null && mailConfig.getPassword().length() != 0) {
            MailSessionAuthenticator authenticator = new MailSessionAuthenticator(mailConfig.getUsername(), mailConfig.getPassword());
            session = Session.getInstance((Properties)props, (Authenticator)authenticator);
        } else {
            session = Session.getInstance((Properties)props, null);
        }
        return session;
    }

    public static String headerStripper(String header) {
        if (!Strings.isNullOrBlank(header)) {
            String s = header.trim();
            if (s.matches("^<.*>$")) {
                return header.substring(1, header.length() - 1);
            }
            return header;
        }
        return header;
    }

    public static MimeMessage createMimeMessage(EmailMessage e, Session session) {
        BaseMailMessage b = new BaseMailMessage(session, e.getCharset(), e.getRootContentType());
        if (!Strings.isNullOrBlank(e.getMessageId())) {
            b.setMessageID(e.getMessageId());
        }
        b.setFrom(e.getFromAddresses());
        b.addRecipients(RecipientType.TO, e.getToAddresses());
        b.addRecipients(RecipientType.CC, e.getCcAddresses());
        b.addRecipients(RecipientType.BCC, e.getBccAddresses());
        b.setReplyTo(e.getReplyToAddresses());
        b.addDeliveryRecieptAddresses(e.getDeliveryReceiptAddresses());
        b.addReadRecieptAddresses(e.getReadReceiptAddresses());
        b.setImportance(e.getImportance());
        b.addHeaders(e.getHeaders());
        if (e.getSubject() != null) {
            b.setSubject(e.getSubject());
        }
        if (e.getType() == EmailMessageType.STANDARD) {
            if (e.getHtmlBody() != null && e.getTextBody() != null) {
                b.setHTMLTextAlt(e.getHtmlBody(), e.getTextBody());
            } else if (e.getTextBody() != null) {
                b.setText(e.getTextBody());
            } else if (e.getHtmlBody() != null) {
                b.setHTML(e.getHtmlBody());
            }
            b.addAttachments(e.getAttachments());
        } else if (e.getType() == EmailMessageType.INVITE_ICAL) {
            b.setHTMLNotRelated(e.getHtmlBody());
            b.addAttachments(e.getAttachments());
        } else {
            throw new SendFailedException("Unsupported Message Type: " + e.getType());
        }
        MimeMessage msg = b.getFinalizedMessage();
        return msg;
    }

    public static void send(EmailMessage e, Session session) throws SendFailedException {
        MimeMessage msg = MailUtility.createMimeMessage(e, session);
        try {
            Transport.send((Message)msg);
        }
        catch (MessagingException e1) {
            throw new SendFailedException("Send Failed", (Throwable)e1);
        }
        try {
            e.setMessageId(null);
            e.setLastMessageId(MailUtility.headerStripper(msg.getMessageID()));
        }
        catch (MessagingException e1) {
            throw new SendFailedException("Unable to read Message-ID from sent message");
        }
    }
}

