/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.attachments;

import java.util.ArrayList;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.jboss.seam.mail.core.Header;
import org.jboss.seam.mail.core.enumerations.ContentDisposition;

public class AttachmentPart
extends MimeBodyPart {
    private String uid;

    public AttachmentPart(DataSource dataSource, String uid, String fileName, Collection<Header> headers, ContentDisposition contentDisposition) {
        this.uid = uid;
        try {
            this.setContentID("<" + uid + ">");
        }
        catch (MessagingException e1) {
            throw new RuntimeException("Unable to set unique content-id on attachment");
        }
        this.setData(dataSource);
        if (fileName != null) {
            try {
                this.setFileName(fileName);
            }
            catch (MessagingException e) {
                throw new RuntimeException("Unable to get FileName on attachment");
            }
        }
        if (headers != null) {
            for (Header header : headers) {
                try {
                    this.addHeader(header.getName(), header.getValue());
                }
                catch (MessagingException e) {
                    throw new RuntimeException("Unable to add Content-Class Header");
                }
            }
        }
        this.setContentDisposition(contentDisposition);
    }

    public AttachmentPart(byte[] bytes, String uid, String fileName, String mimeType, Collection<Header> headers, ContentDisposition contentDisposition) {
        this((DataSource)AttachmentPart.getByteArrayDataSource(bytes, mimeType), uid, fileName, headers, contentDisposition);
    }

    public AttachmentPart(byte[] bytes, String uid, String fileName, String mimeType, ContentDisposition contentDisposition) {
        this((DataSource)AttachmentPart.getByteArrayDataSource(bytes, mimeType), uid, fileName, new ArrayList<Header>(), contentDisposition);
    }

    public String getAttachmentFileName() {
        try {
            return this.getFileName();
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to get File Name from attachment");
        }
    }

    public ContentDisposition getContentDisposition() {
        try {
            return ContentDisposition.mapValue((String)this.getDisposition());
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to get Content-Dispostion on attachment");
        }
    }

    public String getUid() {
        return this.uid;
    }

    public void setContentDisposition(ContentDisposition contentDisposition) {
        try {
            this.setDisposition(contentDisposition.headerValue());
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to set Content-Dispostion on attachment");
        }
    }

    private void setData(DataSource datasource) {
        try {
            this.setDataHandler(new DataHandler(datasource));
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to set Data on attachment");
        }
    }

    private static ByteArrayDataSource getByteArrayDataSource(byte[] bytes, String mimeType) {
        ByteArrayDataSource bads = new ByteArrayDataSource(bytes, mimeType);
        return bads;
    }
}

