/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.jndi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import javax.naming.NameNotFoundException;

public class BridgeContext
implements InvocationHandler {
    private Context primaryCtx;
    private Context secondaryCtx;

    public static Context createBridge(Context primaryCtx, Context secondaryCtx) {
        BridgeContext h = new BridgeContext(primaryCtx, secondaryCtx);
        Class[] interfaces = new Class[]{Context.class};
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)h);
    }

    BridgeContext(Context primaryCtx, Context secondaryCtx) {
        this.primaryCtx = primaryCtx;
        this.secondaryCtx = secondaryCtx;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object value;
        try {
            value = method.invoke((Object)this.primaryCtx, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof NameNotFoundException && method.getName().startsWith("lookup")) {
                try {
                    value = method.invoke((Object)this.secondaryCtx, args);
                }
                catch (InvocationTargetException e1) {
                    throw e1.getTargetException();
                }
            }
            throw t;
        }
        return value;
    }
}

