/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.helpers;

import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;

public class DirectRootResourceOwnerFinder
implements ResourceOwnerFinder {
    private static ResourceOwnerFinder instance;
    private static Method currentRootGetter;

    private static Method getLookupMethod() throws Exception {
        ClassLoader cl = ResourceContext.class.getClassLoader();
        Class<?> clazz = cl.loadClass("org.jboss.classloading.spi.visitor.RootAwareResource");
        return clazz.getDeclaredMethod("getRootUrl", new Class[0]);
    }

    private DirectRootResourceOwnerFinder() {
    }

    public static boolean isValid() {
        return currentRootGetter != null;
    }

    public static ResourceOwnerFinder getInstance() {
        if (!DirectRootResourceOwnerFinder.isValid()) {
            throw new IllegalArgumentException("Invalid finder, cannot access root url directly.");
        }
        if (instance == null) {
            instance = new DirectRootResourceOwnerFinder();
        }
        return instance;
    }

    public URL findOwnerURL(ResourceContext resource) {
        try {
            return (URL)currentRootGetter.invoke((Object)resource, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            SecurityManager sm = System.getSecurityManager();
            currentRootGetter = sm == null ? DirectRootResourceOwnerFinder.getLookupMethod() : AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return DirectRootResourceOwnerFinder.getLookupMethod();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

