/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.helpers;

import java.util.HashSet;
import java.util.Set;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.plugins.helpers.AbstractScanningHandleAggregator;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentScanningHandleAggregator<T extends ScanningHandle, U>
extends AbstractScanningHandleAggregator<T, U> {
    private DeploymentUnit unit;

    public DeploymentScanningHandleAggregator(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        this.unit = unit;
    }

    public U getAggregatedHandle(ScanningPlugin<T, U> plugin) {
        Set<U> handles = this.findHandles(plugin);
        return this.aggregate(plugin, handles);
    }

    private Set<U> findHandles(ScanningPlugin<T, U> plugin) {
        DeploymentUnit top;
        for (top = this.unit; top != null && !top.isAttachmentPresent(Module.class); top = top.getParent()) {
        }
        if (top == null) {
            throw new IllegalArgumentException("No CL module: " + this.unit);
        }
        HashSet handles = new HashSet();
        this.recurse(top, plugin, handles, true);
        return handles;
    }

    private void recurse(DeploymentUnit current, ScanningPlugin<T, U> plugin, Set<U> handles, boolean allowModule) {
        if (!allowModule && current.isAttachmentPresent(Module.class)) {
            return;
        }
        Object handle = current.getAttachment(plugin.getAttachmentKey(), plugin.getHandleInterface());
        if (handle != null) {
            handles.add(handle);
        }
        for (DeploymentUnit child : current.getChildren()) {
            this.recurse(child, plugin, handles, false);
        }
    }
}

