/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.test.EmbeddedContainer;
import org.junit.After;
import org.junit.Before;

public abstract class BaseResourceTest {
    protected boolean manualStart;
    protected Hashtable<String, String> initParams = new Hashtable();
    protected Hashtable<String, String> contextParams = new Hashtable();
    protected ResteasyDeployment deployment;
    protected Dispatcher dispatcher;

    @Before
    public void before() throws Exception {
        if (!this.manualStart) {
            this.startContainer();
        }
    }

    protected void createContainer(Hashtable<String, String> initParams, Hashtable<String, String> contextParams) throws Exception {
        this.initParams = initParams;
        this.contextParams = contextParams;
        this.startContainer();
    }

    protected void startContainer() throws Exception {
        if (this.deployment == null) {
            this.deployment = EmbeddedContainer.start(this.initParams, this.contextParams);
            this.dispatcher = this.deployment.getDispatcher();
        }
    }

    protected void startContainerIfNotRunning() {
        try {
            this.startContainer();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not start TJWS container " + e.getMessage(), e);
        }
    }

    @After
    public void after() throws Exception {
        this.stopContainer();
    }

    protected void stopContainer() throws Exception {
        if (this.deployment != null) {
            EmbeddedContainer.stop();
        }
        this.dispatcher = null;
        this.deployment = null;
    }

    public Registry getRegistry() {
        this.startContainerIfNotRunning();
        return this.deployment.getRegistry();
    }

    public ResteasyProviderFactory getProviderFactory() {
        this.startContainerIfNotRunning();
        return this.deployment.getProviderFactory();
    }

    public void addPerRequestResource(Class<?> resource, Class<?> ... otherResources) {
        this.startContainerIfNotRunning();
        this.deployment.getRegistry().addPerRequestResource(resource);
    }

    protected void addPackageInfo(Class<?> clazz) {
    }

    public void registerProvider(Class<?> clazz) {
        this.startContainerIfNotRunning();
        this.deployment.getProviderFactory().registerProvider(clazz);
    }

    public void addExceptionMapper(Class<? extends ExceptionMapper<?>> clazz) {
        this.startContainerIfNotRunning();
        this.deployment.getProviderFactory().addExceptionMapper(clazz);
    }

    public String readString(InputStream in) throws IOException {
        char[] buffer = new char[1024];
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int wasRead = 0;
        do {
            if ((wasRead = reader.read(buffer, 0, 1024)) <= 0) continue;
            builder.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        return builder.toString();
    }

    public void addLibraryWithTransitiveDependencies(String Gav) {
    }
}

