/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.tracing.InterceptorTimestampPair;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public abstract class AbstractWriterInterceptorContext
implements WriterInterceptorContext {
    protected RESTEasyTracingLogger tracingLogger;
    protected WriterInterceptor[] interceptors;
    protected Object entity;
    protected Class type;
    protected Type genericType;
    protected Annotation[] annotations;
    protected MediaType mediaType;
    protected MultivaluedMap<String, Object> headers;
    protected OutputStream outputStream;
    protected int index = 0;
    protected ResteasyProviderFactory providerFactory;
    private InterceptorTimestampPair<WriterInterceptor> lastTracedInterceptor;

    public int getProcessedInterceptorCount() {
        return this.index;
    }

    @Deprecated
    public AbstractWriterInterceptorContext(WriterInterceptor[] interceptors, Annotation[] annotations, Object entity, Type genericType, MediaType mediaType, Class type, OutputStream outputStream, ResteasyProviderFactory providerFactory, MultivaluedMap<String, Object> headers) {
        this.providerFactory = providerFactory;
        this.interceptors = interceptors;
        this.annotations = annotations;
        this.entity = entity;
        this.genericType = genericType;
        this.mediaType = mediaType;
        this.type = type;
        this.outputStream = outputStream;
        this.headers = headers;
        this.tracingLogger = RESTEasyTracingLogger.empty();
    }

    public AbstractWriterInterceptorContext(WriterInterceptor[] interceptors, Annotation[] annotations, Object entity, Type genericType, MediaType mediaType, Class type, OutputStream outputStream, ResteasyProviderFactory providerFactory, MultivaluedMap<String, Object> headers, RESTEasyTracingLogger logger2) {
        this.providerFactory = providerFactory;
        this.interceptors = interceptors;
        this.annotations = annotations;
        this.entity = entity;
        this.genericType = genericType;
        this.mediaType = mediaType;
        this.type = type;
        this.outputStream = outputStream;
        this.headers = headers;
        this.tracingLogger = logger2;
        if (logger2 == null) {
            this.tracingLogger = RESTEasyTracingLogger.empty();
        }
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            throw new NullPointerException(Messages.MESSAGES.annotationsParamNull());
        }
        this.annotations = annotations;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void proceed() throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor Context: %s,  Method : proceed", this.getClass().getName());
        if (this.interceptors == null || this.index >= this.interceptors.length) {
            MessageBodyWriter writer = this.getWriter();
            if (writer != null) {
                this.tracingLogger.log("MBW_WRITE_TO", writer.getClass().getName());
                LogMessages.LOGGER.debugf("MessageBodyWriter: %s", writer.getClass().getName());
            }
            this.writeTo(writer);
        } else {
            LogMessages.LOGGER.debugf("WriterInterceptor: %s", this.interceptors[this.index].getClass().getName());
            int x = this.index;
            this.traceBefore(this.interceptors[x]);
            try {
                this.interceptors[this.index++].aroundWriteTo((WriterInterceptorContext)this);
            }
            finally {
                this.traceAfter(this.interceptors[x]);
            }
        }
    }

    protected final void traceBefore(WriterInterceptor interceptor) {
        if (this.tracingLogger.isLogEnabled("WI_BEFORE")) {
            if (this.lastTracedInterceptor != null && interceptor != null) {
                this.tracingLogger.logDuration("WI_BEFORE", this.lastTracedInterceptor.getTimestamp(), this.lastTracedInterceptor.getInterceptor());
            }
            this.lastTracedInterceptor = new InterceptorTimestampPair<WriterInterceptor>(interceptor, System.nanoTime());
        }
    }

    protected final void traceAfter(WriterInterceptor interceptor) {
        if (this.tracingLogger.isLogEnabled("WI_AFTER")) {
            if (this.lastTracedInterceptor != null && this.lastTracedInterceptor.getInterceptor() != null) {
                this.tracingLogger.logDuration("WI_AFTER", this.lastTracedInterceptor.getTimestamp(), interceptor);
            }
            this.lastTracedInterceptor = new InterceptorTimestampPair<WriterInterceptor>(interceptor, System.nanoTime());
        }
    }

    protected void writeTo(MessageBodyWriter writer) throws IOException {
        writer.writeTo(this.entity, this.type, this.genericType, this.annotations, this.mediaType, this.headers, this.outputStream);
    }

    protected MessageBodyWriter getWriter() {
        MessageBodyWriter writer = this.resolveWriter();
        if (writer == null) {
            this.throwWriterNotFoundException();
        }
        return writer;
    }

    protected abstract MessageBodyWriter resolveWriter();

    abstract void throwWriterNotFoundException();
}

